/**
 * httpdサーバのサンプルです。
 * ROMにある定義済みファイルの入出力と、クロスドメインRESTが確認できます。
 */
#include "boot/sketch.h"
#include "NyLPC_net.h"

#include "NyLPC_http.h"
#include "NyLPC_utils.h"


NyLPC_TcNet_t net;
struct MyHttpd{
	NyLPC_TcHttpd_t super;
}httpd;

#define NUM_OF_FSDATA 4
extern struct NyLPC_TRomFileData fsdata[];


void handler(NyLPC_TcHttpdConnection_t* i_connection)
{
	NyLPC_TcModUrl_t mod;
	char url[64];


	//SHORT URL
	NyLPC_cModUrl_initialize(&mod);
	if(!NyLPC_cModUrl_execute(&mod,i_connection,url,64)){
		NyLPC_cModUrl_finalize(&mod);
		return;
	}
	NyLPC_cHttpdConnection_sendResponseHeader(i_connection,200,"text/html",NULL);
	NyLPC_cHttpdConnection_sendResponseBodyF(i_connection,"<html><h1>Your request path is %s</h1></html>",url);
	NyLPC_cModUrl_finalize(&mod);
	return;
}
void setup(void)
{
	//uipサービス初期化。いろいろ利用可能に。
	NyLPC_cNet_initialize(&net);
	NyLPC_cHttpd_initialize(&httpd.super,3000);
	httpd.super.function.onRequest=handler;

}


void loop(void)
{
	NyLPC_TcNetConfig_t c2;
	//192.168.0.39
	NyLPC_cNetConfig_initialize(&c2,NyLPC_TBool_TRUE);
	NyLPC_cNet_start(&net,&c2);
	NyLPC_cHttpd_loop(&httpd.super);
	for(;;);
}


