#!/usr/bin/perl
#
# Script generating translation templates from sources
#
# Miranda IM: the free IM client for Microsoft* Windows*
# 
# Copyright 2000-2008 Miranda ICQ/IM project,
# all portions of this codebase are copyrighted to the people
# listed in contributors.txt.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use POSIX;
use File::Find;
use strict;
use warnings;

my $rootdir = '';
my %hash = ();
my $clines = 0;

my $version = '';
my $version_file = '../../miranda/include/m_version.h';
my $time = localtime();

my $vermaj = '';
my $vermin = '';
my $build = '';

if (@ARGV && $ARGV[0] eq "version") {
	shift @ARGV;
	$vermaj = shift @ARGV;
	$vermin = shift @ARGV;
	$build = shift @ARGV;
}
else
{
#Get default version number from m_version.h
	($vermaj, $vermin, $build) = get_version( $version_file );
}

	# 1st arg version major i.e. 07 for "0.7"
		if ($vermaj =~ /^([0-9]*)([0-9])$/) {
			if ($1 eq "") {
				$version = $2;
			} else {
				$version = "$1.$2";
			}
		} else {
			$version = $vermaj;
		}
	# 2nd arg version minor i.e. 1 for "0.7.1"
		if ($vermin =~ /^[0-9]+$/) {
			$version .= ".$vermin";
		} else {
			$version .= $vermin;
		}

	# 3rd arg build number i.e. 36 for "0.7.1 build 36"
		if ($build =~ /^[0-9]+$/) {
			$version .= " build $build";
		} else {
			$version .= $build;
		}

#Language Files
#If you want to get keywords from *trans*.txt also, set Options '/all' or 'version xx xx xx /all'.
if (!@ARGV || $ARGV[0] eq "/all" ) {
	create_langfile(
		'../../miranda',
		'../../miranda/i18n/langpack_english.txt',
		'English (US)', '0809',
		'Miranda IM Development Team',
		'project-info@miranda-im.org',
		'Scriver,avs,chat,clist,clist_nicer,db3x,db3x_mmap,dbrw,advaimg,import,modernb,mwclist,png2dib,srmm,tabsrmm,AimOscar,Gadu-Gadu,IRC,IcqOscarJ,JabberG,MSN,Yahoo');
}
elsif ($ARGV[0] eq "core") {
	create_langfile('../../miranda/src',
		'../../miranda/i18n/core-translation.txt',
		'English (US)', '0809',
		'Miranda IM Development Team',
		'project-info@miranda-im.org');
}
elsif ($ARGV[0] eq "srmm") {
	create_langfile('../../miranda/plugins/SRMM/',
		'../../miranda/plugins/SRMM/Docs/srmm-translation.txt',
		'English (US)', '0809',
		'Miranda IM Development Team',
		'project-info@miranda-im.org');
}
elsif ($ARGV[0] eq "import") {
	create_langfile('../../miranda/plugins/Import/',
		'../../miranda/plugins/Import/docs/import-translation.txt',
		'English (US)', '0809',
		'Miranda IM Development Team',
		'project-info@miranda-im.org');
}
else {
	print "Error: Unknown module $ARGV[0]\n";
	exit 1;
}

sub create_langfile {
	$rootdir = shift(@_);
	my $outfile = shift(@_);
	my $lang = shift(@_);
	my $locale = shift(@_);
	my $author = shift(@_);
	my $email = shift(@_);
	my $plugins = @_ ? shift(@_) : '';
	%hash = ();
	my %common = ();
	$clines = 0;
	print "Building language file for $rootdir:\n";
	find({ wanted => \&csearch, preprocess => \&pre_dir }, $rootdir);
	find({ wanted => \&rcsearch, preprocess => \&pre_dir }, $rootdir);
	if( @ARGV && $ARGV[0] eq "/all" )
	{
		find({ wanted => \&txtsearch, preprocess => \&pre_dir }, $rootdir);
	}

	open(WRITE, "> $outfile") or die;
	print WRITE <<HEADER;
Miranda Language Pack Version 1
Locale: $locale
Authors: $author
Author-email: $email
Last-Modified-Using: Miranda IM $version
Plugins-included: $plugins
; Generated by lpgen on $time
; Translations: $clines

HEADER
	foreach my $trans (keys %hash) {
		if ($hash{$trans} =~ /^\d+$/) {
			$common{$trans} = $hash{$trans};
			delete $hash{$trans};
		}
	}

	my @sorted = sort { (floor($common{$b}/20) == floor($common{$a}/20)) ? ($a cmp $b) : ($common{$b} <=> $common{$a}) } keys %common;
	print WRITE "; Common strings that belong to many files\n;[";
	print WRITE join "]\n;[", @sorted;
	print WRITE "]\n";

	my $file = '';
	foreach my $trans (sort { ($hash{$a} eq $hash{$b}) ? ($a cmp $b) : ($hash{$a} cmp $hash{$b}) } keys %hash) {
		if ($hash{$trans} ne $file) {
			$file = $hash{$trans};
			print WRITE "\n; $file\n";
		}
		print WRITE ";[$trans]\n";
	}

	close(WRITE);
	print "  $outfile is complete ($clines)\n\n";
}

sub pre_dir {
	# avoid parsing some ext SDKs
	my @files = ();
	return @files if (
		$File::Find::name =~/..\/extplugins/ or
		$File::Find::name =~/freeimage\/Source/ or
		$File::Find::name =~/dbrw\/sqlite3/);
	@files = grep { not /^\.\.?$/ } @_;
	return sort @files;
}

sub append_str {
	my $str = shift(@_);
	my $found = shift(@_);
	if (length($str) gt 0 and $str ne "List1" and $str ne "Tree1" and $str =~ /[a-zA-Z]+/g) {
		my $path = $File::Find::name;
		$path =~ s/(\.\.\/)+miranda\///;
		if (!$hash{$str}) {
			$hash{$str} = $path;
			$clines ++;
			return 1;
		} elsif ($hash{$str} ne $path) {
			if ($hash{$str} =~ /^\d+$/) {
				$hash{$str} ++;
			} else {
				$hash{$str} = 1;
			}
		}
	}
	return 0;
}

sub csearch {
	if (-f $_ and ($_ =~ m/\.c(pp)?$/i or $_ =~ m/\.h(pp)?$/i)) {
		my $found = 0;
		my $file = $_;
		print "  Processing $_ ";
		open(READ, "< $_") or return;
		my $all = '';
		while (my $lines = <READ>) {
			$all = $all.$lines;
		}
		close(READ);
		$_ = $all;
		s/\\\n//g;
		while (/(?:Button_SetIcon_IcoLib|Translate[A-Z]{0,2}|LPGENT?|ICQTranslateUtfStatic)\s*\(\s*\"([^\\]*?(\\.[^\\]*?)*)\"\s*[,\)]/g) {
			$found += append_str($1, $found);
		}
		print "($found)\n";
	}
}

sub rcsearch {
	if ( -f $_ and $_ =~ m/\.rc$/i) {
		my $found = 0;
		my $file = $_;
		print "  Processing $_ ";
		open(READ, "< $_") or return;
		my $all = '';
		while (my $lines = <READ>) {
			$all = $all.$lines;
		}
		close(READ);
		$_ = $all;
		s/\"\"/\\\"/g;
		while (/\s*(?:CONTROL|(?:DEF)?PUSHBUTTON|[LRC]TEXT|GROUPBOX|CAPTION|MENUITEM|POPUP)\s*\"([^\\]*?(\\.[^\\]*?)*)\"/g) {
			$found += append_str($1, $found);
		}
		print "($found)\n";
	}
}

sub txtsearch {
	if ( -f $_ and $_ =~ m/.*?trans.*?\.txt$/i) {
		my $found = 0;
		my $file = $_;
		print "  Processing $_ ";
		open(READ, "< $_") or return;
		my $all = '';
		while (my $lines = <READ>) {
			$all = $all.$lines;
		}
		close(READ);
		$_ = $all;
		while ( /\[(.*?)\]\n/g ) {
			$found += append_str($1, $found);
		}
		print "($found)\n";
	}
}

sub get_version
{
	my $version_file = shift(@_);
	my @version_no = ('','','');
	my $build = '';

	open my $fh, '<', $version_file
		or die qq/Error : Cannot open "$version_file": $!/;

	while( my $get_line = <$fh> )
	{
		chomp $get_line;
		if( $get_line =~ /^\#define MIRANDA_VERSION_STRING\s*?\"(\d*?\.\d*?)\.(\d*?)\.(\d*?)\"/)
		{
			if( $3 != 0 )
			{
				$build = $3;			
			}
			@version_no = ($1,$2,$build);
			last;
		}
	}
	close $fh;
	return @version_no;
}
