/**
 * MOA Text v0.2.0 - Mouse Over Animation for Text in jQuery
 * Written by Osamu AKAMATSU (Bitmeister Inc.)
 * 
 * Copyright (c) Bitmeister Inc.
 * 
 * This software is under the MIT license (MIT-LICENSE.txt).
 *
 * http://sourceforge.jp/projects/moatext/
 *
 * Bitmeister Inc.
 * http://www.bitmeister.jp
 * 
 * @author Osamu AKAMATSU (Bitmeister Inc.)
 * @version 0.2.0
 *
 * You can use this jQuery plugin for adding flavor to your web site.
 * By this plugin, text messages on your site are animated on mouse over.
 * 
 * Usage
 *   Call the moatext() function or set prefixed class on your page.
 *
 *   By function
 *     $(selector).moatext(options)
 *     
 *     <script type="text/javascript" language="JavaScript"><!--
 *       $(function(){
 *         $(".moamoa").moatext();
 *       });
 *     // -->
 *     </script>
 *     
 *     <div class="moamoa">This message is animated!</div>
 *     
 *     *If moatext() is called no parameter, default effect 'lens' is performed.
 *   
 *   By prefixed class
 *     <div class="moatext_lens">This message is animated!</div>
 *     
 *     class             description
 *     ----------------------------------
 *     "moatext_lens"    'lens' effect
 *     "moatext_wave"    'wave' effect
 *     "moatext_opacity" 'opacity' effect
 *     
 *     *About effects, please read below.
 *   
 * options
 * 
 *   effect:[effect1,effect2...]
 *     "lens"        animate font-size (default)
 *     "wave"        animate top and right margin
 *     "opacity"     animate opacity (This effect is not fully supported on css standard-compliant mode of IE.)
 *   oneway:{true/false}
 *     true        effect only at mouseover
 *     false       effect at mouseover and mouseleave (default)
 *   values:{effect:{base:base-value,enter:enter-value,leave:leave-value},...}
 *     effect = "lens"
 *                 CSS 'font-size' value.
 *     effect = "wave"
 *                 CSS 'top' and 'left' value.
 *     effect = "opacity"
 *                 CSS 'opacity' value.
 *     base-value  Used at on loading the page.
 *     enter-value Used at entering mouse.
 *     leave-value Used at leaving mouse.
 *   hover:[function1,function2]
 *      function    replace the animate function launched at mouseover to the user-customized hover functions
 *                  Attention: If this option is used, all the other options are ignored.
 *                  default : null (don't replace)
 *   easing:
 *      xxxx        animation easing value
 *                  default : linear
 */
(function(jQuery) {
    jQuery.fn.moatext = function(options){
        var options = jQuery.extend( {},jQuery.fn.moatext.defaults,options);
        var valuedic = jQuery.fn.moatext.valuesdefaults;
        var basecss = {};
		var entercss_str = '';
		var leavecss_str = '';
		var moaclass_str = 'moa_char';
		var moafunc_str = 'moa_func';
        if (options.hover == null) {
			var lens_str = 'lens';
			var wave_str = 'wave';
			var base_str = 'base';
			var opacity_str = 'opacity';
			var enter_str = 'enter';
			var leave_str = 'leave';
            if (options.values != null) {
                for (var valuekey in options.values) {
                    for (var subvaluekey in options.values[valuekey]) {
                        valuedic[valuekey][subvaluekey] = options.values[valuekey][subvaluekey];
                    }
                }
            }
            options.values = valuedic;
            for (var effectNo in options.effects) {
                var effects = options.effects[effectNo];
                if (options.effects[effectNo] == lens_str) {
                    basecss['font-size'] = options.values[effects][base_str];
                    entercss_str += '"' +'fontSize' + '":"' + options.values[effects][enter_str] + '",';
                    leavecss_str += '"' + 'fontSize' + '":"' + options.values[effects][leave_str] + '",';
                }
                else if (options.effects[effectNo] == wave_str) {
                    basecss['top'] = options.values[effects][base_str][0];
                    basecss['left'] = options.values[effects][base_str][1];
                    entercss_str += '"top":"' + options.values[effects][enter_str][0] + '","left":"' + options.values[effects][enter_str][1] +'",';
                    leavecss_str += '"top":"' + options.values[effects][leave_str][0] + '","left":"' + options.values[effects][leave_str][1] +'",';
                }
                else if (options.effects[effectNo] == opacity_str) {
                    basecss['opacity'] = basecss['-moz-opacity'] = options.values[effects][base_str];
                    basecss['filter'] = 'alpha(opacity="'+Math.floor(parseFloat(options.values[effects]["base"])*100) + '")';
//                    entercss_str += '"opacity":"' + options.values[effects][enter_str] + '","MozOpacity":"' + options.values[effects][enter_str] + '","filter":"alpha(opacity='+ Math.floor(parseFloat(options.values[effects][enter_str])*100) +')",';
//                    leavecss_str += '"opacity":"' + options.values[effects][leave_str] + '","MozOpacity":"' + options.values[effects][leave_str] + '","filter":"alpha(opacity='+ Math.floor(parseFloat(options.values[effects][leave_str])*100) +')",';
                    entercss_str += '"opacity":"' + options.values[effects][enter_str] + '",';
                    leavecss_str += '"opacity":"' + options.values[effects][leave_str] + '",';
                }
            }
        }
		moaclass_str += jQuery.fn.moatext.class_no.toString();
		moafunc_str += jQuery.fn.moatext.class_no.toString();
		jQuery.fn.moatext.class_no += 1;
		if (options.hover != null) {
			jQuery.fn.moatext.customfuncs[moafunc_str+'0'] = options.hover[0];
			jQuery.fn.moatext.customfuncs[moafunc_str+'1'] = options.hover[1];
			var func_def = "jQuery.fn.moatext."+moafunc_str+" = function(target){jQuery(target).hover(function(ev){jQuery.fn.moatext.customfuncs['" + moafunc_str + "0'](ev.target);},function(ev){jQuery.fn.moatext.customfuncs['" + moafunc_str + "1'](ev.target);});};";
			eval(func_def);
		}else {
			var duration_str = '';
			if (isNaN(Number(options.duration))) {
				duration_str = '"' + options.duration + '"';
			}
			else {
				duration_str += options.duration;
			}
			var func_leave_def = '';
			if (options.oneway == true) {
				func_leave_def = ';';
			}
			else {
				func_leave_def = ".animate({" + leavecss_str.substring(0,leavecss_str.length-1) + '},' + duration_str + ',"' + options.easing + '",function(){jQuery(target).css("position","static");});';
			}
			var func_def = "jQuery.fn.moatext."+moafunc_str+" = function(target){jQuery(target).css('position','relative');jQuery(target).animate({"+entercss_str.substring(0,entercss_str.length-1)+"}," + duration_str + ',"'+options.easing+'")'+func_leave_def + '};';
			eval(func_def);
		}
        var array = [];
        this.each(function(){
            var jqobj = jQuery(this);
            var baseString = jqobj.html();
            var wrappedString = "";
            var mode = 0;
			var debugString = "";
            for (var i = 0; i < baseString.length; i++) {
				var theChar = baseString.charAt(i);
                if (mode == 0) {
                    if (theChar == '<') {
                        mode = 1;
                        wrappedString = wrappedString + theChar;
                        continue;
                    }
                }
                else if (mode == 1) {
                    if (theChar == '>') {
                        mode = 0;
                    }
                    wrappedString = wrappedString + theChar;
                    continue;
                }
                if (theChar == ' ' || theChar == '\r' || theChar == '\n') {
                    wrappedString = wrappedString + theChar;
                }
                else {
                    wrappedString += '<span class="' + moaclass_str + '" onmouseover="jQuery.fn.moatext.'+moafunc_str+'(this)">' + theChar + '</span>';
                }
            }
			if (options.hover == null) {
				if (document.compatMode != 'BackCompat' && basecss['opacity'] != null && jQuery.support.opacity == false) {
					jqobj.html(wrappedString).css('opacity',basecss['opacity']).find("span."+moaclass_str).css(basecss);
				}
				else {
					jqobj.html(wrappedString).find("span."+moaclass_str).css(basecss);
				}
			}
			else {
				jqobj.html(wrappedString);
			}
            array.push(jqobj);
        });
        return array;
    };
    
    jQuery.fn.moatext.valuesdefaults = {
        "lens":{"base":"100%","enter":"200%","leave":"100%"},
        "wave":{"base":["0px","0px"],"enter":["-10px","-10px"],"leave":["0px","0px"]},
        "opacity": {"base":"0.1","enter":"1.0","leave":"0.1"}
    };

	jQuery.fn.moatext.customfuncs = {};
    jQuery.fn.moatext.defaults = {
        effects: ["lens"],
        oneway: false,
        values: null,
        hover: null,
        easing: "linear",
        duration: 1000,
        animation: true
    };
    jQuery.fn.moatext.key_class = "moatext";
    jQuery.fn.moatext.class_no = 1;

})(jQuery);

jQuery(function(){
    if (jQuery.fn.moatext.key_class != null && jQuery.fn.moatext.key_class.length > 0) {
        jQuery("."+jQuery.fn.moatext.key_class).moatext();
        jQuery("."+jQuery.fn.moatext.key_class+"_lens").moatext({effects:["lens"]});
        jQuery("."+jQuery.fn.moatext.key_class+"_wave").moatext({effects:["wave"]});
        jQuery("."+jQuery.fn.moatext.key_class+"_opacity").moatext({effects:["opacity"]});
    }
});
