/*
  =============================================================================
  
   Class   : クラス定義
   
  =============================================================================
*/

/*
  -----------------------------------------------------------------------------
  
  Define : 色々
  
  -----------------------------------------------------------------------------
*/
#define boolean int
#define true 1                  /* 算術演算 真 */
#define false 0                 /* 算術演算 偽 */
#define null ((void *)0)        /* null */

/*
  -----------------------------------------------------------------------------
  
  CLASS : 基本リンク
  
  -----------------------------------------------------------------------------
*/
#define NOS_LINK                                \
    struct Nos_Link *next;                      \
    union                                       \
    {                                           \
        unsigned int pri;                       \
        int timer;                              \
        int id;                                 \
        int len;                                \
        int stat;                               \
    } info

struct Nos_Link                 /* Nos_Msgの先頭も同じ */
{
    NOS_LINK;
};

/*
  -----------------------------------------------------------------------------
  
  Define : システム設定
  
  -----------------------------------------------------------------------------
*/
#include "nos_conf.h"

/*
  -----------------------------------------------------------------------------
  
  Define : TICk値
  
  -----------------------------------------------------------------------------
*/
#if NOS_TICK_TIME <= 0
#udef NOS_TICK_TIME
#define NOS_TICK_TIME 1
#endif

#if USE_NOS_MEM & USE_NOS_B0
/*
  -----------------------------------------------------------------------------
  
  Define : メモリ情報
  
  -----------------------------------------------------------------------------
*/
#if NOS_MEM_ALLOC == 0
#undef NOS_MEM_ALLOC
#define NOS_MEM_ALLOC 7
#endif

struct Nos_Page
{
    struct Nos_Page *next;       /* 次のブロック */
    NOS_MEM_PAGE size;           /* ページ数 */
 
    short int buf[((1 << NOS_MEM_ALLOC)
                   - sizeof(struct Nos_Page *) - sizeof(NOS_MEM_PAGE)) >> 1];
};

struct Nos_Mem {

    struct Nos_Page alloc;      /* メモリアロケーション情報 */
    struct Nos_Link wait;       /* メモリ待機Queue */
};

#if USE_NOS_DEBUG
extern struct Nos_Mem nos_mem;
#endif

extern NOS_MEM_PAGE sensMem(boolean);
extern void *initMem(void *, NOS_MEM_PAGE);
extern void *allocMem(NOS_MEM_PAGE);
extern void *purgeMem(void *);
#endif

/*
  -----------------------------------------------------------------------------
  
  CLASS : Slot構造体
  
  -----------------------------------------------------------------------------
*/
struct Nos_Slot
{
    NOS_LINK;
    boolean (*thread)(void);    /* 呼び出すスレッド */
    int id;                     /* タスクID */
#if (USE_NOS_TIMER & USE_NOS_B0 | USE_NOS_MEM) & USE_NOS_B0
    union {
#if USE_NOS_TIMER & USE_NOS_B0
        unsigned int pri;       /* 本来の優先順位 */
#endif
#if USE_NOS_MEM & USE_NOS_B0
        NOS_MEM_PAGE size;      /* 要求メモリサイズ */
#endif
    } wait;
#endif
};

#if USE_NOS_MSG & USE_NOS_B0
/*
  -----------------------------------------------------------------------------
  
  Struct : メッセージボックス
  
  -----------------------------------------------------------------------------
*/
struct Nos_Box
{
    struct Nos_Link task;       /* メッセージ待ち Task Queue */
    struct Nos_Link msg;        /* メッセージ Queue */
};

#if USE_NOS_DEBUG
extern struct Nos_Buf nos_mes;
extern struct Nos_Box nos_box[];
#endif

extern void *sendMsg(int, void *);
extern void *recvMsg(int);
extern int sensMsg(int);
#endif

#if USE_NOS_RESRC & USE_NOS_B0
/*
  -----------------------------------------------------------------------------
  
  Define : リソース管理
  
  -----------------------------------------------------------------------------
*/
struct Nos_Resrc
{
    NOS_LINK;
        
    int lock;                   /* ロックID */
#if USE_NOS_RESRC & USE_NOS_B1
    unsigned int pri;           /* タスク優先度ワーク */
#endif
};

#if USE_NOS_DEBUG
extern struct Nos_Resrc nos_res[];
#endif

#if USE_NOS_RESRC & USE_NOS_B1
extern int getResrc(int, int);
#else
extern int getResrc(int);
#endif
extern int purgeResrc(int);
extern int sensResrc(int);
#endif

/*
  -----------------------------------------------------------------------------
  
  CLASS : イベント情報
  
  -----------------------------------------------------------------------------
*/
#if USE_NOS_EVENT & USE_NOS_B0

#if USE_NOS_DEBUG
extern struct Nos_Link nos_event[];
#endif

extern int waitEvent(int);
extern int setEvent(int);
extern int clearEvent(int);
extern int sensEvent(int);
#endif

/*
  -----------------------------------------------------------------------------
  
  CLASS : タイマー
  
  -----------------------------------------------------------------------------
*/
#if USE_NOS_TIMER & USE_NOS_B0
extern int nos_timer;           /* TIMER値 */

#if USE_NOS_DEBUG
extern struct Nos_Link nos_time;
#endif

extern int wakeupTask(int);
extern int sleepTask(int);
#endif

/*
  -----------------------------------------------------------------------------
  
  CLASS : nos.h
  
  -----------------------------------------------------------------------------
*/
struct Nos
{
    struct Nos_Slot *now;       /* 現在実行中のTask */
    struct Nos_Link *queue;     /* 終了時に配置するqueue */

    struct Nos_Link run;        /* 実行Queue */


    struct Nos_Link free;       /* 空きタスクリスト */
    struct Nos_Slot slot[NUM_NOS_TASK];
                                /* タスク管理用ブロック */

};
extern int nos_tick;            /* TICK値 */

#if USE_NOS_DEBUG
extern struct Nos nos_sys;
#endif

extern void initNos(void);
extern void runSched(void);
extern int nextThread(boolean (*)(void));
extern boolean nextTask(void);
extern int purgeTask(void);
extern int runTask(boolean (*)(void), unsigned int);
