//
//  NKFCocoa.m
//  NKFCocoa
//
//  Created by hippos on 08/12/29.
//  Copyright 2008 hippos-lab.com. All rights reserved.
//

#import "NKFCocoa.h"
#import "NKFCocoaLocal.h"

NSStringEncoding nkfmain(int argc,char **argv,NSError** error);

@implementation NSData (NKFCocoa)

+ (NSStringEncoding)guessByNKFWithURL:(NSURL *)url error : (NSError **)error
{
  char *argv[] =
  {
    "NKFCocoa", "--guess", (char *)[[url path] cStringUsingEncoding:NSUTF8StringEncoding], "\0"
  };

  NSError         *nkferror = nil;
  NSStringEncoding enc      = nkfmain(3, argv, &nkferror);
  if (nkferror)
    {
      if (error != NULL)
        {
          NSString     *recoverySuggestion = [NSString stringWithFormat:@"%@(%@)",NSLocalizedString(@"NKFCocoaRecoverySuggestionWrongURLString",@""),[url path]];
          NSArray      *errObjArray = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaNKFErrorString",@""), nkferror,recoverySuggestion, nil];
          NSArray      *errKeyArray = [NSArray arrayWithObjects:NSLocalizedDescriptionKey, NSUnderlyingErrorKey, NSLocalizedRecoverySuggestionErrorKey, nil];
          NSDictionary *errDict     = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaNKFError userInfo:errDict] autorelease];
        }
      return 0;
    }
  return enc;
}

- (NSStringEncoding)guessByNKF:(NSError * *)error
{
  char temp[256];

  if (![self NKFCocoaLocal_makeMksTemp:temp error:error])
    {
      return 0;
    }
  
  NSURL *write_url = [NSURL fileURLWithPath:[NSString stringWithCString:temp]];

  NSError* cocoaerr = nil;
  if (![self writeToURL:write_url options:NSAtomicWrite error:&cocoaerr])
    {
      if (error!=NULL)
        {
          NSString     *recoverySuggestion = [NSString stringWithFormat:@"%@",NSLocalizedString(@"NKFCocoaRecoverySuggestionTemporaryFileCreateFailedString",@"")];
          NSArray      *errObjArray = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaWriteToURLErrorString", @""),recoverySuggestion, cocoaerr, nil];
          NSArray      *errKeyArray = [NSArray arrayWithObjects:NSLocalizedDescriptionKey,NSLocalizedRecoverySuggestionErrorKey, NSUnderlyingErrorKey, nil];
          NSDictionary *errDict     = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaWriteToURLError userInfo:errDict] autorelease];
        }
      return 0;
    }

  char *argv[] =
  {
    "NKFCocoa", "--guess", (char *)[[write_url path] cStringUsingEncoding:NSUTF8StringEncoding], "\0"
  };

  NSError         *nkferror = nil;
  NSStringEncoding enc      = nkfmain(3, argv, &nkferror);
  unlink(temp);
  if (nkferror)
    {
      if (error != NULL)
        {
          NSArray      *errObjArray = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaNKFErrorString", @""), nkferror, nil];
          NSArray      *errKeyArray = [NSArray arrayWithObjects:NSLocalizedDescriptionKey, NSUnderlyingErrorKey, nil];
          NSDictionary *errDict     = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaNKFError userInfo:errDict] autorelease];
        }
      return 0;
    }
  return enc;
}

- (NSStringEncoding)guessByNKFWithRange:(NSRange)range error:(NSError * *)error
{
  
  char temp[256];
  if (![self NKFCocoaLocal_makeMksTemp:temp error:error])
    {
      return 0;
    }
  
  NSURL  *write_url = [NSURL fileURLWithPath:[NSString stringWithCString:temp]];

  @try 
    {
      NSData *sub_data  = [self subdataWithRange:range];
      [sub_data writeToURL:write_url atomically:YES];
    }
  @catch(NSException* e)
    {
      if (error != NULL)
        {
          *error = [[[NSError alloc] initWithDomain:NSCocoaErrorDomain code:NKFCocoaRangeError userInfo:[e userInfo]] autorelease];
        }
      unlink(temp);
      return 0;
    }

  
  char *argv[] =
  {
    "NKFCocoa", "--guess", (char *)[[write_url path] cStringUsingEncoding:NSUTF8StringEncoding], "\0"
  };

  NSError         *nkferror = nil;
  NSStringEncoding enc      = nkfmain(3, argv, &nkferror);
  unlink(temp);
  if (nkferror)
    {
      if (error != NULL)
        {
          NSString     *recoverySuggestion = [NSString stringWithFormat:@"%@(%d:%d)",NSLocalizedString(@"NKFCocoaRecoverySuggestionWrongRangeString",@""), range.location, range.length];
          NSArray      *errObjArray  = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaNKFErrorString", @""),recoverySuggestion ,nkferror, nil];
          NSArray      *errKeyArray  = [NSArray arrayWithObjects:NSLocalizedDescriptionKey,NSLocalizedRecoverySuggestionErrorKey, NSUnderlyingErrorKey, nil];
          NSDictionary *errDict      = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaNKFError userInfo:errDict] autorelease];
        }
      return 0;
    }
  return enc;
}

- (NSString *)stringByNKFWithOptions:(NSString *)options error:(NSError * *)error
{
  char temp[256];
  if (![self NKFCocoaLocal_makeMksTemp:temp error:error])
    {
      return nil;
    }
  NSURL *url = [NSURL fileURLWithPath:[NSString stringWithCString:temp]];
  [self writeToURL:url atomically:YES];

  NSArray     *opts = [self NKFCocoaLocal_makeNKFOptionsWithURL:options url:url];
  char       **argv = malloc(sizeof(char *) * ([opts count] + 1));
  unsigned int pos  = 0;
  for (pos = 0; pos <[opts count]; pos++)
    {
      argv[pos] = (char *)[[opts objectAtIndex:pos] cStringUsingEncoding:NSUTF8StringEncoding];
    }
  argv[pos] = "\0";
  
  NSError         *nkferror = nil;
  NSStringEncoding enc = nkfmain([opts count], argv, &nkferror);
  free(argv);

  if (nkferror)
    {
      if (error != NULL)
        {
          NSString     *recoverySuggestion = [NSString stringWithFormat:@"%@(%@)",NSLocalizedString(@"NKFCocoaRecoverySuggestionWrongOptionsString",@""), options];
          NSArray      *errObjArray  = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaNKFErrorString", @""),recoverySuggestion ,nkferror, nil];
          NSArray      *errKeyArray  = [NSArray arrayWithObjects:NSLocalizedDescriptionKey,NSLocalizedRecoverySuggestionErrorKey, NSUnderlyingErrorKey, nil];
          NSDictionary *errDict      = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaNKFError userInfo:errDict] autorelease];
        }
      unlink(temp);
      return nil;
    }
  
  NSError         *err      = nil;
  NSString        *string   = [NSString stringWithContentsOfURL:url encoding:enc error:&err];

  if (string==nil && err)
    {
      if (error != NULL)
        {
          NSString     *recoverySuggestion = [NSString stringWithFormat:@"%@(%@)",NSLocalizedString(@"NKFCocoaRecoverySuggestionWrongOptionsString",@""), options];
          NSArray      *errObjArray  = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaStringWithContentsOfURLString", @""),recoverySuggestion ,nkferror, nil];
          NSArray      *errKeyArray  = [NSArray arrayWithObjects:NSLocalizedDescriptionKey,NSLocalizedRecoverySuggestionErrorKey, NSUnderlyingErrorKey, nil];
          NSDictionary *errDict      = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaStringWithContentsOfURL userInfo:errDict] autorelease];
        }
    }

  unlink(temp);
  return string;
}

- (NSData *)dataByNKFWithOptions:(NSString *)options error:(NSError * *)error
{
  char temp[256];

  if (![self NKFCocoaLocal_makeMksTemp:temp error:error])
    {
      return nil;
    }
  NSURL *url = [NSURL fileURLWithPath:[NSString stringWithCString:temp]];
  [self writeToURL:url atomically:YES];

  NSArray     *opts = [self NKFCocoaLocal_makeNKFOptionsWithURL:options url:url];
  char       **argv = malloc(sizeof(char *) * ([opts count] + 1));
  unsigned int pos  = 0;
  for (pos = 0; pos <[opts count]; pos++)
    {
      argv[pos] = (char *)[[opts objectAtIndex:pos] cStringUsingEncoding:NSUTF8StringEncoding];
    }
  argv[pos] = "\0";

  NSError *nkferror = nil;
  nkfmain([opts count], argv, &nkferror);
  free(argv);
  if (nkferror)
    {
      if (error != NULL)
        {
          NSString     *recoverySuggestion = [NSString stringWithFormat:@"%@(%@)", NSLocalizedString(@"NKFCocoaRecoverySuggestionWrongOptionsString", @""), options];
          NSArray      *errObjArray        = [NSArray arrayWithObjects:NSLocalizedString(@"NKFCocoaNKFErrorString", @""), recoverySuggestion, nkferror, nil];
          NSArray      *errKeyArray        = [NSArray arrayWithObjects:NSLocalizedDescriptionKey, NSLocalizedRecoverySuggestionErrorKey, NSUnderlyingErrorKey, nil];
          NSDictionary *errDict            = [NSDictionary dictionaryWithObjects:errObjArray forKeys:errKeyArray];
          *error = [[[NSError alloc] initWithDomain:NKFCocoaErrorDomain code:NKFCocoaNKFError userInfo:errDict] autorelease];
        }
    }

  NSData *data = [NSData dataWithContentsOfURL:url];
  unlink(temp);
  return data;
}

- (NSArray *)NKFCocoaLocal_makeNKFOptionsWithURL:(NSString *)options url:(NSURL *)url
{
  NSMutableArray *opts = nil;

  ((options == nil) || ([options length] == 0)) ?
      (opts = [[[NSMutableArray alloc] init] autorelease]) :
      (opts = [NSMutableArray arrayWithArray:[options componentsSeparatedByString:@" "]]);

  NSMutableArray* nkfOptions = [[[NSMutableArray alloc] init] autorelease];
  NSEnumerator *enumerator = [opts objectEnumerator];
  NSString     *opt        = nil;
  
  // remove invalid option
  while((opt=[enumerator nextObject]) != nil)
    {
      if (([opt compare:@"--in-place" options:NSCaseInsensitiveSearch] != NSOrderedSame) &&
          ([opt compare:@"--orverwrite" options:NSCaseInsensitiveSearch] != NSOrderedSame) &&
          ([opt compare:@"--help" options:NSCaseInsensitiveSearch] != NSOrderedSame) &&
          ([opt compare:@"--version" options:NSCaseInsensitiveSearch] != NSOrderedSame))
        {
          [nkfOptions addObject:opt];
        }
    }
  [nkfOptions insertObject:@"NKFCocoa" atIndex:0];
  [nkfOptions addObject:@"--in-place"];
  [nkfOptions addObject:[url path]];
  return nkfOptions;
}

- (BOOL)NKFCocoaLocal_makeMksTemp:(char *)tempFileBuf error:(NSError * *)error
{
  strcpy(tempFileBuf, "nkfcocoa.nkfcocoatmp.XXXXXX");
  int fd = mkstemp(tempFileBuf);
  if (0 > fd)
    {
      if (error != NULL)
        {
          *error = [[[NSError alloc] initWithDomain:NSPOSIXErrorDomain code:errno
                     userInfo:[NSDictionary dictionaryWithObjects:[NSArray arrayWithObjects:[NSString stringWithFormat:@"%s", strerror(errno)], nil] forKeys:[NSArray arrayWithObjects:NSLocalizedDescriptionKey, nil]]] autorelease];
        }
      return NO;
    }
  return YES;
}

@end
