#include "stdafx.h"

#include "nlite_include.h"


namespace nlite{

static const RECT commentViewSize = {5,0,5,0};

///
///萔
///
enum{
	IDC_COMBO_REBAR = 301,
	IDC_COMBO_TITLE = 302
};



///
///EBhEŒTCY
///
const static SIZE lowestFrameSize = {300,300};



CNliteMainFrame::~CNliteMainFrame(){

	DeleteObject(hTabFont);
}

CNliteMainFrame::CNliteMainFrame()
	:userData(*this),
	subLiveNoComboBox(*this),
	commentWriteWindow(nicoLiveStream),
	commentView(nicoLiveStream,nicoVideoAuth)
{
	LOGFONT lf = {0};

	lf.lfHeight = 10;
	lf.lfCharSet = SHIFTJIS_CHARSET;
	hTabFont = CreateFontIndirect(&lf);
}


// bZ[WtB^
BOOL CNliteMainFrame::PreTranslateMessage(MSG* pMsg){
	// NXPreTranslateMessageĂяo
	return CFrameWindowImpl<CNliteMainFrame>::PreTranslateMessage(pMsg);
}

// ACh
BOOL CNliteMainFrame::OnIdle(){
	return FALSE;
}

//TCYύX
VOID CNliteMainFrame::ChangeSize(const SIZE& client){

	
	UINT_PTR tabheight = client.cy - (toolBarHeight + statusBarHeight + commentWriteWindow.GetHeight());

	
	RECT tabWindowRect = {0};
	RECT commentViewRect = {0};
	RECT commentWriteWindowRect = {0};


	tabWindowRect.left = 0;
	tabWindowRect.top = toolBarHeight;
	tabWindowRect.right =  client.cx - tabWindowRect.left;
	tabWindowRect.bottom = tabWindowRect.top + tabheight;
	
	
	commentWriteWindowRect.left = 0;
	commentWriteWindowRect.top = tabWindowRect.bottom;
	commentWriteWindowRect.right = commentWriteWindowRect.left + client.cx;
	commentWriteWindowRect.bottom = commentWriteWindowRect.top + commentWriteWindow.GetHeight();


	

	tabctrl.MoveWindow(tabWindowRect.left,tabWindowRect.top,tabWindowRect.right - tabWindowRect.left ,tabWindowRect.bottom - tabWindowRect.top);
	
	
	tabctrl.GetClientRect(&commentViewRect);
	tabctrl.AdjustRect(FALSE,&commentViewRect);

	commentView.MoveWindow(commentViewRect.left, commentViewRect.top,commentViewRect.right - commentViewRect.left, commentViewRect.bottom - commentViewRect.top);

	commentWriteWindow.MoveWindow(commentWriteWindowRect.left,commentWriteWindowRect.top,commentWriteWindowRect.right - commentWriteWindowRect.left ,commentWriteWindowRect.bottom - commentWriteWindowRect.top);
	commentWriteWindow.Invalidate();
	::InvalidateRect(m_hWndStatusBar,NULL,TRUE);

//	tabctrl.SetWindowPos(*this,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);
//	commentWriteWindow.SetWindowPos(*this,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE | SWP_SHOWWINDOW);
	return;
}

LRESULT CNliteMainFrame::OnCbSelChange(UINT hiWparam,int loWparam,HWND lParam){

	if(lParam == this->lvNoCombo){
		INT_PTR cursel = this->lvNoCombo.GetCurSel();
		if(cursel == CB_ERR)goto end;
		auto it = this->subLiveNoComboBox.liveInfoList.begin();
		std::advance(it,cursel);
		this->ConnectNicoLive(it->second);

	}

end:

	return 0;
}

LRESULT CNliteMainFrame::OnCreate(LPCREATESTRUCT lpcs){

	
	// Xe[^Xo[쐬
	m_hWndStatusBar = m_hStatusBar.Create(*this);
	UIAddStatusBar(m_hWndStatusBar);
	// Xe[^Xo[ɃyCݒ
	//INT_PTR nPanes[] = {ID_DEFAULT_PANE, IDS_PANE_TIME};
	//m_hStatusBar.SetPanes(nPanes, sizeof(nPanes)/sizeof(nPanes[0]));
	//progresBar.Create(m_hWnd,0,NULL,);
	//m_hStatusBar.SetClipboardViewer
	tabctrl.Create(m_hWnd,0,NULL,WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_DLGFRAME );
	commentView.Create(tabctrl.m_hWnd);
	
	commentWriteWindow.Create(m_hWnd,0,NULL,WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN  );
	CreateSimpleReBar();
	HWND hWndToolBar = CreateSimpleToolBarCtrl(m_hWnd,IDC_NLITE, FALSE, ATL_SIMPLE_TOOLBAR_PANE_STYLE);
	lvNoCombo.Create(m_hWnd, CRect(0, 0, 100, 100), NULL,WS_CHILD | WS_VISIBLE | WS_VSCROLL  | CBS_DROPDOWN | CBS_AUTOHSCROLL, 0, IDC_COMBO_REBAR);
	lvNoCombo.LimitText(LENGTH_512);

	subLiveNoComboBox.SubclassWindow(lvNoCombo.GetEditCtrl());
	lvNoCombo.SetFont(AtlGetDefaultGuiFont());
	
	

	//AddSimpleReBarBand(hWndToolBar);
	AddSimpleReBarBand(lvNoCombo,TEXT("URL"));
	SizeSimpleReBarBands();
	
	//tabctrl.SetWindowPos(*this,0,0,0,0,SWP_SHOWWINDOW);
	
	tabctrl.SetFont(hTabFont);
	tabctrl.AddItem(TCIF_TEXT | TCIF_PARAM, _T("Rgꗗ"), 0, (DWORD)commentView.m_hWnd);

	
		
	// bZ[W[vɃbZ[WtB^ƃAChnhǉ
	CMessageLoop* pLoop = _Module.GetMessageLoop();
	pLoop->AddMessageFilter(this);
	pLoop->AddIdleHandler(this);

	RECT wndRect;
	this->GetWindowRect(&wndRect);
	
	LONG cyMaxImized = GetSystemMetrics (SM_CYMAXIMIZED);
	wndRect.bottom = nliteProperty.mfp.windowSize.cy != 0 ? nliteProperty.mfp.windowSize.cy : (LONG)cyMaxImized / 2;
	wndRect.right = nliteProperty.mfp.windowSize.cx != 0 ? nliteProperty.mfp.windowSize.cx : commentViewSize.left + commentViewSize.right + 20 + commentView.GetColumnHolSizeSum();

	

	RECT statusbarRect;
	::GetClientRect(m_hWndStatusBar,&statusbarRect);

	statusBarHeight = statusbarRect.bottom - statusbarRect.top;
	
	

	this->MoveWindow(wndRect.left,wndRect.top,wndRect.right,wndRect.bottom);
	
	listenerSettingWindow.Create(*this);
	
	this->SetMenuItemCheck(IDM_FRONT_WINDOW_CHECK,nliteProperty.mfp.windowFrontFlag);
	this->SetMenuItemCheck(IDM_SPEAK_COMMENT_CHECK,nliteProperty.crp.commentReadFlag);
	
	this->SetWindowPos(nliteProperty.mfp.windowFrontFlag == TRUE ? HWND_TOPMOST : HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE);

	return 0;
}



VOID CNliteMainFrame::Initialize(LPCTSTR localAppDataPath){

	try{
		nliteProperty.ReadProperty();

	
		if((nliteProperty.gp.ncvUserSettingReadedFlag == FALSE) && 
			((PathFileExists(ncvAppSettingPath) &&  (!::PathIsDirectory( ncvAppSettingPath ))))){
		
			if((::MessageBox(NULL,TEXT("NCṼXi[Ɠ܂H"),TEXT("Xi[ǂݍ"),MB_OK | MB_OKCANCEL) == IDOK)){
				listenerList.ReadProperty(GetNCVListenerInfoFilePath());
			}
			nliteProperty.gp.ncvUserSettingReadedFlag = TRUE;
		

			
			
		}

		listenerList.ReadProperty(nliteProperty.listenerDataPath);

		commentView.SetProperty(nliteProperty.cvp,nliteProperty.gp);
		if(nliteProperty.gp.browserType == BT_NOSETTING){
			nliteProperty.CookieSetting();
			while(nliteProperty.gp.browserType == BT_NOSETTING){
				::MessageBox(NULL,TEXT("uEU^Cvw肵ĂBȊÕuEU͌ݎgp邱Ƃ͂ł܂"),TEXT("uEU^CvwG["),MB_OK);
				nliteProperty.CookieSetting();
			}
		}
			
		nicoVideoAuth.SetBrowserType(nliteProperty.gp.browserType);
		nicoLiveStream.SetResFrom(200);
	}catch(Exception &e){

		::MessageBox(NULL,e.what(),TEXT("ݒt@Cǂݍ݃G["),MB_OK | MB_ICONERROR);

	}
	return;
			
}

VOID CNliteMainFrame::OnClose(){
	this->ShowWindow(SW_HIDE);
	nicoLiveStream.DisConnect();
	this->DestroyWindow();
	
	return;
}

VOID CNliteMainFrame::OnDestroy(){
	
	commentView.DestroyWindow();
			
	PostQuitMessage(0);
	return;
}


VOID CNliteMainFrame::OnException(){

	nicoLiveStream.DisConnect();

}


BOOL CNliteMainFrame::IsMenuItemChecked(UINT item){
	MENUITEMINFO menuInfo;
	menuInfo.fMask = MIIM_STATE;
	menuInfo.cbSize = sizeof(menuInfo);
	::GetMenuItemInfo(this->GetMenu(),item,FALSE,&menuInfo);
	return menuInfo.fState == MFS_CHECKED;
}


VOID CNliteMainFrame::SetMenuItemCheck(UINT item,BOOL state){
	MENUITEMINFO menuInfo;
	menuInfo.cbSize = sizeof(menuInfo);
	menuInfo.fMask = MIIM_STATE;
	menuInfo.fState = state == TRUE ? MFS_CHECKED :MFS_UNCHECKED;
	::SetMenuItemInfo(this->GetMenu(),item,FALSE,&menuInfo);

}

//j[t@CII
VOID CNliteMainFrame::OnMenuExit(UINT uNotifyCode, int nID, HWND hWndCtl){
	PostMessage(WM_CLOSE);
}

//j[̃AvP[Vo[W\
VOID CNliteMainFrame::OnMenuAbount(UINT uNotifyCode,int nID,HWND hWndCtl){
	appInfo->show();
}

VOID CNliteMainFrame::Finalaize(){

	nliteProperty.cvp = commentView.GetProperty();
	nliteProperty.WriteProperty();
	listenerList.WriteProperty(nliteProperty.listenerDataPath);
}

VOID CNliteMainFrame::OnViewPreference(UINT uNotifyCode,int nID,HWND hWndCtl){

	//ViewerPropertyWindow propetyWindow(TEXT("r[Aݒ"));
	
	//propetyWindow.DoModal();

	return;
}

LRESULT CNliteMainFrame::OnUnlockLvNoBuffer(UINT uMsg,WPARAM wParam,LPARAM lParam){
	this->lvNoBufCS.Unlock();
	return 0;
}

//NbL[̐ݒ
VOID CNliteMainFrame::OnCookie(UINT uNotifyCode,int nID,HWND hWndCtl){
	nliteProperty.CookieSetting();
			
	while(nliteProperty.gp.browserType == BT_NOSETTING){
		::MessageBox(NULL,TEXT("uEU^Cvw肵ĂBȊÕuEU͌ݎgp邱Ƃ͂ł܂"),TEXT("uEU^CvwG["),MB_OK);
		nliteProperty.CookieSetting();
	}
			
	try {
		nicoVideoAuth.SetBrowserType(nliteProperty.gp.browserType);
	} catch(NLIBException &e){

		MessageBox(e.what(),TEXT("NbL[擾s"),MB_OK | MB_ICONERROR);

	}
	

}

VOID CNliteMainFrame::OnSpeakCommentCheck(UINT uNotifyCode,int nID,HWND hWndCtl){


	nliteProperty.crp.commentReadFlag = !IsMenuItemChecked(IDM_SPEAK_COMMENT_CHECK);
	SetMenuItemCheck(IDM_SPEAK_COMMENT_CHECK,nliteProperty.crp.commentReadFlag );
	
	return;
}

VOID CNliteMainFrame::OnFrontWindowCheck(UINT uNotifyCode,int nID,HWND hWndCtl){


	nliteProperty.mfp.windowFrontFlag = !IsMenuItemChecked(IDM_FRONT_WINDOW_CHECK);
	SetMenuItemCheck(IDM_FRONT_WINDOW_CHECK,nliteProperty.mfp.windowFrontFlag );
	this->SetWindowPos(nliteProperty.mfp.windowFrontFlag == TRUE ? HWND_TOPMOST : HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE | SWP_NOMOVE);
	return;
}

VOID CNliteMainFrame::ConnectingThread(LPVOID userData){

	auto &self = *(CNliteMainFrame*)userData;
	CString lvNoString = self.lvNoBuffer;
	self.SendMessage(UM_UNLOCK_LVNOBUFFER,(WPARAM)0,(LPARAM)0);
	try {
		self.nicoLiveStream.DisConnect();
		self.commentView.OnConnect();
		
	
		NLIB_RESULT code = self.nicoLiveStream.Connect(self.nicoVideoAuth,lvNoString,LiveCallBack,&self.userData);

		//G[R[h
		switch(code){
	
			//I
		case NLIB_ERR_OK:

			
			goto end;

			//z肳ꂽG[R[h
		case NLIB_ERR_COOKIE_FAILED:
		case NLIB_LIVENO_FAILED_UNDEFEINE:
		case NLIB_FAILED_CONNECT:
		case NLIB_ERR_GETPLAYERSTATUS_INVALID_LV:
		case NLIB_ERR_GETPLAYERSTATUS_INVALID_THREAD:
		case NLIB_ERR_GETPLAYERSTATUS_CLOSED:
		case NLIB_ERR_GETPLAYERSTATUS_UNKNOWN_ERROR:
		case NLIB_ERR_GETPLAYERSTATUS_SERVER_ERROR:
		case NLIB_ERR_GETPLAYERSTATUS_DELETED:
		case NLIB_ERR_GETPLAYERSTATUS_FULL:
		case NLIB_ERR_GETPLAYERSTATUS_PERMISSION_DENIED:
		case NLIB_ERR_GETPLAYERSTATUS_ACCESS_LOCKED:
		case NLIB_ERR_GETPLAYERSTATUS_REQUIRE_COMMUNITY_MEMBER:
		case NLIB_ERR_GETPLAYERSTATUS_COMINGSOON:
		case NLIB_ERR_GETPLAYERSTATUS_NOTFOUND:
		case NLIB_ERR_GETPLAYERSTATUS_NOTLOGIN:
		case NLIB_ERR_GETPLAYERSTATUS_UNKNOWN:
		case NLIB_ERR_GETPLAYERSTATUS_MAINTENANCE:
		case NLIB_ERR_GETPLAYERSTATUS_NOT_PERMITTED:
		case NLIB_ERR_GETPLAYERSTATUS_REQUIRE_ACCEPT_PRINT_TIMESHIFT_TICKET:
		case NLIB_ERR_GETPLAYERSTATUS_TSARCHIVE:
		case NLIB_ERR_GETPLAYERSTATUS_USERTIMESHIFT:
		case NLIB_ERR_GETPLAYERSTATUS_UNDEFINED:
		case NLIB_ERR_GETPLAYERSTATUS_NOAUTH:
		case NLIB_ERR_GETPLAYERSTATUS_CHANT_PARSE:
		case NLIB_ERR_GETPLAYERSTATUS_BLOCK_NOW_COUNT_OVERFLOW:


			
			::MessageBox(self,NLIB_GetErrorMessage(code),TEXT("ڑG["),MB_ICONERROR | MB_OK);

			break;


			//z肳ĂȂG[R[h
		default:
		
			UnexpectedErrorMessageShow( TEXT("ڑ"),NLIB_GetErrorMessage(code),__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

		
			break;

		}
		self.subLiveNoComboBox.AgreeInputLvNo();
		

	} catch(nlib::Exception &e){

		UnexpectedErrorMessageShow( TEXT("ڑ"),e.what(),e.getLineNo(),e.getFileName(),e.getFunctionName());

	}
end:
	
	self.subLiveNoComboBox.AgreeInputLvNo();
	_endthread();
	return;
}


BOOL CNliteMainFrame::ConnectNicoLive(LPCTSTR liveNo){
	
	lvNoCombo.GetEditCtrl().SetReadOnly(TRUE);
	subLiveNoComboBox.untilConnectingFlag = TRUE;
	EnableWindow(FALSE);
	lvNoBufCS.Lock();
	this->lvNoBuffer = liveNo;
	_beginthread(CNliteMainFrame::ConnectingThread,0,this);

	


	return TRUE;

}


//TCYύX
LRESULT CNliteMainFrame::OnSize(UINT uMsg,WPARAM wParam,LPARAM lParam,BOOL& bHandled){


	SIZE clientSize;
	clientSize.cx = LOWORD(lParam);
	clientSize.cy = HIWORD(lParam);
	ChangeSize(clientSize);

	bHandled = FALSE;
			
			

	return 0;
}


///
///TCYύX
///
VOID CNliteMainFrame::OnSizing(UINT wParam,LPRECT lParam){
			
	if(lParam->right - lParam->left < lowestFrameSize.cx){
		lParam->right = lParam->left + lowestFrameSize.cx;
	}

	if(lParam->bottom - lParam->top < lowestFrameSize.cy){

		lParam->bottom = lParam->top + lowestFrameSize.cy;
	}
			
}


//c[o[ύX
LRESULT CNliteMainFrame::OnRbnHeightChange(INT_PTR wParam,LPNMHDR lParam,BOOL &bHandled){

	RECT toolbarRect;
	::GetClientRect(m_hWndToolBar,&toolbarRect);
	toolBarHeight = toolbarRect.bottom - toolbarRect.top;

	RECT client;
	GetClientRect(&client);

	ChangeSize( _WTYPES_NS::CSize(client.right - client.left,client.bottom - client.top));



	return 0;
}

LRESULT CNliteMainFrame::OnUpDateUI(UINT uMsg,WPARAM wParam,LPARAM lParam){


	commentView.UpDateUI();

	return 0;
}

LRESULT CNliteMainFrame::OnClickChatNo(UINT uMsg,WPARAM wParam,LPARAM lParam){

	auto &chatData = *(CChatData*)wParam;
	CString setString;
	if(chatData.listenerData->name.Length() == 0){
		setString.Format(TEXT(">>%d "),chatData.no);
	}else{
		setString.Format(TEXT(">>%s "),chatData.listenerData->name);
	}

	this->commentWriteWindow.SetText(setString);

	return 0;

}

LRESULT CNliteMainFrame::OnClickUserName(UINT uMsg,WPARAM wParam,LPARAM lParam){

	auto &chatData = *(CChatData*)wParam;
	listenerSettingWindow.ShowSettingWindow(*chatData.listenerData);


	return 0;
}


NLIB_RESULT CNliteMainFrame::LiveCallBack(NICOLIVE_EVENT eventType,NicoLiveStream_P pNicoLiveStream,LPVOID option,NICOLIVE_PARAM param1,NICOLIVE_PARAM param2){

	CLiveUserData &userData = (*(CLiveUserData*)option);

	try{
		

		switch(eventType){

		case NICOLIVE_EVENT_RECEVE_CONNECTRESULT:

			userData.OnChatReceveStart(userData.self.nicoLiveStream,(NicoLiveThreadComment_P)param1);

			break;

		case NICOLIVE_EVENT_RECEVE_CHAT:

			userData.OnChatReceve((NicoLiveChat_P) param1,param2);

			break;

		case NICOLIVE_EVENT_RECEVE_CHATSETTLE:

			userData.OnChatReceveSettle(param1,param2);

			break;

		case NICOLIVE_EVENT_RECEVE_CHATSENDRESULT:

			userData.OnChatSendResult(reinterpret_cast<NicoLiveSendResultComment_P>(param1));

			break;

		case NICOLIVE_EVENT_SEND_HEARTBEAT:

			userData.OnHeartBeat(reinterpret_cast<NicoLiveHeartBeat_P>(param1));

			break;


		case NICOLIVE_EVENT_DISCONNECT:

			userData.OnDisconnect();

			break;

		case NICOLIVE_EVENT_ERR_CONNECT:

			throw NLiveException(TEXT("ڑG[ł"),__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			break;

		default:

			throw NLiveException(TEXT("\ȂbZ[WM܂"),__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			break;
		}

	} catch(Exception e){
		UnexpectedErrorMessageShow(TEXT("nhĂȂG["),e.what(),e.getLineNo(),e.getFileName(),e.getFunctionName());
	
	} catch(std::exception e){
		UnexpectedErrorMessageShow(TEXT("nhĂȂs̃G["),CComBSTR(e.what()),-1,TEXT("t@Co܂"),TEXT("֐ł܂"));
	}
	

	

	return NLIB_ERR_OK;
}


LRESULT CNliteMainFrame::OnSetCursor(LRESULT msg,WPARAM wParam,LPARAM lParam,BOOL &bHandled){

	
	BOOL rslt = FALSE;
	
	if(this->subLiveNoComboBox.untilConnectingFlag == TRUE || this->commentWriteWindow.IsWrighthing() == TRUE){
		
		if(this->subLiveNoComboBox.untilConnectingFlag == TRUE){
			::SetCursor(::LoadCursorW(NULL,IDC_WAIT));
		} else if(this->commentWriteWindow.IsWrighthing() == TRUE){
			::SetCursor(::LoadCursorW(NULL,IDC_APPSTARTING));
		}
		bHandled = TRUE;
		rslt = TRUE;
	



	} else {
		bHandled = FALSE;
	}
	

	return TRUE;

}


//
//CSubLiveNoComboBox
////////////////////////////////////

CNliteMainFrame::CSubLiveNoComboBox::CSubLiveNoComboBox(CNliteMainFrame &in_self):self(in_self),untilConnectingFlag(FALSE){}

static VOID AgreeEnterKeyThread(LPVOID userData){

	Sleep(1000);
	auto noCombo = (CNliteMainFrame::CSubLiveNoComboBox*) userData;
	noCombo->AgreeInputLvNo();

	return;
}

VOID CNliteMainFrame::CSubLiveNoComboBox::OnKeyDown(TCHAR wParam, UINT upLParam,UINT loLParam){
	if(wParam == VK_RETURN){
					
		cs.Lock();
					
		//INT_PTR no = self.lvNoCombo.GetCurSel();
		if(untilConnectingFlag == FALSE){
			
			std::vector<TCHAR> buffer(this->GetWindowTextLengthW() + 1); 
			::GetWindowTextW(this->m_hWnd,&buffer[0],buffer.size());
			
			
			self.ConnectNicoLive(&buffer[0]);
		}		
		cs.Unlock();
					
					
	} else {

		this->DefWindowProc();

	}
	return;
}

LRESULT CNliteMainFrame::CSubLiveNoComboBox::OnMouseWheel(UINT loWparam,SHORT hiWparam,CPoint &point){


	return FALSE;
}



VOID CNliteMainFrame::CSubLiveNoComboBox::AddLiveInfo(CNicoLiveStream &stream,LvnoSearchFunctional &functional){
	
	CNLiteString dispComboString;
	dispComboString += stream.GetId();
	dispComboString += TEXT("@-");
	dispComboString += stream.GetDefaultCommunity();
	dispComboString += TEXT("@titleF");
	dispComboString += stream.GetTitle();

	if(std::find_if(liveInfoList.begin(),liveInfoList.end(),functional) == liveInfoList.end()){
		liveInfoList.push_back(LiveInfo(dispComboString,stream.GetId()));
		
		self.lvNoCombo.InsertItem(self.lvNoCombo.GetCount(),dispComboString,0,0,0,0);
	
	} 
	functional.dispData = dispComboString;

	


	return;
}


VOID CNliteMainFrame::CSubLiveNoComboBox::AgreeInputLvNo(){
	cs.Lock();
	self.lvNoCombo.GetEditCtrl().SetReadOnly(FALSE);
	self.EnableWindow(TRUE);
	untilConnectingFlag = FALSE;
	POINT mousePoint;
	::GetCursorPos(&mousePoint);
	::SetCursorPos(mousePoint.x,mousePoint.y);
	cs.Unlock();
}


//
//CLiveUserData
/////////////////////////////////////////////////////////////////////////

CNliteMainFrame::CLiveUserData::CLiveUserData(CNliteMainFrame &self):self(self)
{}



VOID CNliteMainFrame::CLiveUserData::OnConnect(){

	self.commentView.OnConnect();

}


VOID CNliteMainFrame::CLiveUserData::OnChatReceveStart(CNicoLiveStream &stream,NicoLiveThreadComment_P threadComment){
	
	LvnoSearchFunctional functional(stream.GetId());
	self.commentWriteWindow.OnChatReceveStart(stream,threadComment);
	self.subLiveNoComboBox.AddLiveInfo(stream,functional);
	self.subLiveNoComboBox.SetWindowText(functional.dispData);
	self.subLiveNoComboBox.AgreeInputLvNo();
	
	return;
}

VOID CNliteMainFrame::CLiveUserData::OnChatReceve(NicoLiveChat_P chat,UINT_PTR count){

	self.commentView.OnChatReceve(chat,count);
	
}

VOID CNliteMainFrame::CLiveUserData::OnChatReceveSettle(UINT_PTR commentCount,UINT_PTR commentCountSum){

	self.commentView.OnChatReceveSettle(commentCount,commentCountSum);
	
	return;
}

VOID CNliteMainFrame::CLiveUserData::OnChatSendResult(NicoLiveSendResultComment_P sendResult){
	self.commentWriteWindow.OnSendChatResult();
	return;
}


VOID CNliteMainFrame::CLiveUserData::OnHeartBeat(NicoLiveHeartBeat_P heartBeat){

	self.commentWriteWindow.OnHeartBeat(heartBeat);

	return;
}



VOID CNliteMainFrame::CLiveUserData::OnDisconnect(){
	self.commentWriteWindow.OnDisConnect();
	return;
}

}