#include "stdafx.h"
#include "nlite_include.h"

namespace nlite {




	CApplicationInfo::CApplicationInfo(){

		struct LANGANDCODEPAGE {

			WORD  wLanguage;
			WORD wCodePage;
		} *lpTranslate;
		TCHAR szModuleName[_MAX_PATH + 1] = {0};										//AvP[Vt@C
		try{

			DWORD dwReserved;															//t@Ci[p
			LPTSTR errMessage = NULL;													//G[bZ[W

			//AvP[Vt@C擾
			int nRet = GetModuleFileName(NULL,szModuleName,ARRAYSIZE(szModuleName));	

			if(nRet <= 0){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}
			
			//AvP[Vo[W̃TCY擾
			DWORD dwSize = GetFileVersionInfoSize(szModuleName,&dwReserved);

			if(dwSize <= 0){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}

			//Kvȃm
			pBlock = malloc(dwSize);

			if(pBlock == NULL){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}
			//
			//AvP[Vo[W擾
			//
			BOOL bRet = GetFileVersionInfo(szModuleName,0,dwSize,pBlock);

			if(bRet != TRUE){
				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}


			UINT ulen;
			if(VerQueryValue(pBlock,TEXT("\\VarFileInfo\\Translation"),(LPVOID*)&lpTranslate,&ulen) == FALSE){
				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));
			}

			TCHAR subBlock[_MAX_PATH];
			_stprintf(subBlock,TEXT("\\StringFileInfo\\%04x%04x\\ProductVersion"),lpTranslate->wLanguage,lpTranslate->wCodePage);

			if(VerQueryValue(pBlock,subBlock,(LPVOID *)&pProductVersion,&ulen) == FALSE){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			}

			_stprintf(subBlock,TEXT("\\StringFileInfo\\%04x%04x\\OriginalFilename"),lpTranslate->wLanguage,lpTranslate->wCodePage);

			if(VerQueryValue(pBlock,subBlock,(LPVOID *)&pOriginalFileName,&ulen) == FALSE){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			}

			_stprintf(subBlock,TEXT("\\StringFileInfo\\%04x%04x\\LegalCopyright"),lpTranslate->wLanguage,lpTranslate->wCodePage);

			if(VerQueryValue(pBlock,subBlock,(LPVOID *)&pLegalCopyright,&ulen) == FALSE){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			}

			_stprintf(subBlock,TEXT("\\StringFileInfo\\%04x%04x\\ProductName"),lpTranslate->wLanguage,lpTranslate->wCodePage);

			if(VerQueryValue(pBlock,subBlock,(LPVOID *)&pProductName,&ulen) == FALSE){

				throw AppInitException(__LINE__,TEXT(__FILE__),TEXT(__FUNCTION__));

			}


		} catch (const AppInitException& e){


			safeFree(pBlock);

			throw e;
		}

		return;



	}


	CApplicationInfo::~CApplicationInfo(){


		safeFree(pBlock);
	}

	///
	///VOg
	///
	CApplicationInfo& CApplicationInfo::getInstance(){
		static CApplicationInfo appInfo;
		return appInfo;

	}



	LPCTSTR CApplicationInfo::getProductVersion()const{

		return pProductVersion;

	}

	LPCTSTR CApplicationInfo::getOriginalFileName()const{

		return pOriginalFileName;

	}

	LPCTSTR CApplicationInfo::getLegalCopyright()const{

		return pLegalCopyright;

	}

	LPCTSTR CApplicationInfo::getProcuctName() const{

		return pProductName;
	}


	VOID CApplicationInfo::show() const {

		CNLiteString szApp;
		CNLiteString szOtherStuff;


		szApp = pOriginalFileName;
		szApp += TEXT("̃AvP[V");

		szOtherStuff = TEXT("o[W: ");
		szOtherStuff += pProductVersion;
		szOtherStuff += TEXT("\r\n쌠: ");
		szOtherStuff += pLegalCopyright;

		ShellAbout(NULL,szApp,szOtherStuff,NULL);
	}

}