#pragma once

namespace nlite{

	template <typename T>
	struct CommentInfo{
		LPCTSTR name;
		T userData;
	};

	typedef CommentInfo<COLORREF> CommentColorInfo;
	typedef CommentInfo<LPCTSTR> CommentSizeInfo; 
	typedef CommentInfo<LPCTSTR> CommentPosInfo;

	class CNicoLiveStream;

	///
	///ʉR}h
	///
	namespace generalUser{
		///
		///ʉRgFXg
		///
		extern const  CommentColorInfo COMMENT_COLORLIST[];

		///
		///ʉTCYR}hXg
		///
		extern const CommentSizeInfo COMMENT_SIZELIST[];

		///
		///ʉRgʒuXg
		///
		extern const CommentPosInfo COMMENT_POSLIST[];

	}

	///
	///v~AR}h
	///
	namespace premiumUser{
		///
		///v~ARgFXg
		///
		extern const CommentColorInfo COMMENT_COLORLIST[];


		///
		///v~ATCYR}hXg
		///
		extern const CommentSizeInfo COMMENT_SIZELIST[];

		///
		///v~ARgʒuXg
		///
		extern const CommentPosInfo COMMENT_POSLIST[];

	}


	class CCommentWriteWindow;
	class CSubChatEdit:public CWindowImpl<CSubChatEdit,CEdit>{
		friend CCommentWriteWindow;


	private:
		CCommentWriteWindow &self;
		CComAutoCriticalSection cs;
		BOOL untilConnectingFlag;

	public:
		CSubChatEdit(CCommentWriteWindow &in_commentWriteWindow):self(in_commentWriteWindow){}


		BEGIN_MSG_MAP_EX(CSubLiveNoComboBox)
			MSG_WM_KEYDOWN(OnKeyDown)
		END_MSG_MAP()

			void OnKeyDown(TCHAR wParam, UINT upLParam,UINT loLParam);


			VOID AgreeEnter();

			static VOID EnterChatBox(LPVOID userData);
	};


	const static LPCTSTR COMMENTWRITEWINDOW = TEXT("commentWriteWindow");


	///
	///RgݗpEBhENX
	///
	class CCommentWriteWindow:public CWindowImpl<CCommentWriteWindow>{

		friend CSubChatEdit;
	private:
		CComboBox commentPosBox;								//RgʒuIR{{bNX
		CComAutoCriticalSection commentPosBoxCS;				//RgʒuIR{{bNXNeBJZNV
		CComboBox commentSizeBox;								//Rg̑傫IR{{bNX
		CComAutoCriticalSection commentSizeBoxCS;				//Rg̑傫IR{{bNXNeBJZNV
		CComboBox commentColorBox;								//RgFIR{{bNX
		CButton anonymousButton;								//184I{^
		CButton ownerModeButton;								//RI{^
		CSubChatEdit commentSubEdit;							//RgݗpGfBbgTuNX
		CButton commentWriteButton;								//Rg݃{^
		UINT_PTR commentWriteMaxLength;							//Rgݒől
		UINT_PTR commentWriteHeight;							//Rg݃Rg[zü̍
		UINT_PTR infoDispHeight;								//Rg݂Ɋւ̈ȊȌ\̈̍
		UINT_PTR commentWriteInternalHeight;					//Rg݃Rg[zü̍()
		CNicoLiveStream &nicoLiveStream;						//IuWFNg̎Q
		time_t streamTime;										//oߎ
		CFont checkButtonFont;									//184\ptHg
		CFont timeFont;											//oߎԕ\ptHg
		COLORREF editBkColor;									//GfBbg̔wiF
		CBrush editBkBrush;										//GfBbg̔wiuV
		

		//Rg[ID
		enum CONTROLID{
			COMMENTPOS_BOX = 1,
			COMMENTSIZE_BOX = 2,
			COMMENTCOLOR_BOX = 3,
			ANONYMOUS_BUTTON = 4,
			COMMENT_EDIT = 5,
			COMMENTWRITE_BOTTON = 6,
			TIMER_ID = 7,
			OWNERMODE_BUTTON = 5
		};
		


	public:

		DECLARE_WND_CLASS(COMMENTWRITEWINDOW)
		//bZ[W}bv
		BEGIN_MSG_MAP(CCommentWriteWindow)
			MSG_WM_CREATE(OnCreate)
			MSG_WM_DESTROY(OnDestroy)
			MSG_WM_PAINT(OnPaint)
			MSG_WM_SIZE(OnSize)
			MSG_WM_ERASEBKGND(OnEraseBkGnd)
			MSG_WM_CTLCOLOREDIT(OnCtlolorEdit)
			MSG_WM_DRAWITEM(OnDrawItem)
			MSG_WM_MEASUREITEM(OnMeasureItem)
			MSG_WM_TIMER(OnTimer)
			COMMAND_CODE_HANDLER_EX(BN_CLICKED,OnButton)
		END_MSG_MAP()




		public:

		///
		///RXgN^
		///
		CCommentWriteWindow(CNicoLiveStream &nicoLiveStream);

		///
		///ݏݏ̃tOmF
		///
		BOOL IsWrighthing();


		///
		///̃EBhE̍擾
		///
		UINT_PTR GetHeight();

		///
		///RgM
		///
		BOOL SendChat();

		///
		///RgMɕݒ
		///
		BOOL SetText(LPCTSTR lpStr);

		///
		///RgMJn̏
		///
		VOID OnChatReceveStart(CNicoLiveStream &nicoLiveStream,NicoLiveThreadComment_P threadComment);

		///
		///RgMʎM̏
		///
		VOID OnSendChatResult();

		///
		///n[gr[gM̏
		///
		VOID OnHeartBeat(NicoLiveHeartBeat_P heartBeat);

		///
		///ؒf̏
		///
		VOID OnDisConnect();

		//
		//bZ[Wnh
		//
	private:

		///
		///EBhE쐬̏
		///
		LRESULT OnCreate(LPCREATESTRUCT lpReateStruct);


		///
		///EBhEj̏
		///
		VOID OnDestroy();

		///
		///`掞̏
		///
		VOID OnPaint(HDC hdc);


		///
		///TCYύX̏
		///
		LRESULT OnSize(UINT wParam,SIZE lParam);

		///
		///TCYύX
		///
		VOID ChangeSize(SIZE &size);


		///
		///ACe`揈
		///
		VOID OnDrawItem(UINT wParam,LPDRAWITEMSTRUCT lParam);

		///
		///ACe̍ύX
		///
		VOID OnMeasureItem(UINT wParam,LPMEASUREITEMSTRUCT lParam);

		///
		///wĩ`cL}
		///
		LRESULT OnEraseBkGnd(HDC wParam);

		///
		///{^̏
		///
		LRESULT OnButton(UINT hiWparam,INT_PTR loWparam,HWND lParam);


		///
		///GfBbgRg[JX^h[
		///
		LRESULT OnCtlolorEdit(HDC hdc,HWND hWnd);

		VOID OnTimer(UINT id);


	};

}