package org.mineap.nndd.player
{
	import flash.events.AsyncErrorEvent;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	
	import mx.controls.SWFLoader;
	
	import org.mineap.nicovideo4as.model.VideoType;
	import org.mineap.nndd.LogManager;
	import org.mineap.nndd.NNDDDownloader;
	import org.mineap.nndd.android.library.LibraryManager;
	import org.mineap.nndd.android.nnddServer.NNDDServerInfoManager;
	import org.mineap.nndd.android.user.UserManager;
	import org.mineap.nndd.model.NNDDVideo;
	
	import views.VideoPlayView;

	public class PlayerController
	{
		
		private var videoPlayView:VideoPlayView;
		
		private var nnddDownloader:NNDDDownloader = null;
		
		
		// ----動画再生オブジェクト----
		// video
		private var video:Video;
		private var netStream:NetStream;
		
		// swf
		private var swfLoader:SWFLoader;
		
		public function PlayerController(targetView:VideoPlayView)
		{
			
			this.videoPlayView = targetView;
			
		}
		
		public function play(video:NNDDVideo):void
		{
			if (nnddDownloader != null)
			{
				nnddDownloader.close(true, false);
				nnddDownloader = null;
			}
			
			var url:String = video.getDecodeUrl();
			var videoId:String = url.substr(url.lastIndexOf("/") + 1);
			
			var nnddServerAddress:String = NNDDServerInfoManager.instance.nnddServerAddress;
			var nnddServerPort:int = NNDDServerInfoManager.instance.nnddServerPort;
			
			nnddDownloader = new NNDDDownloader();
			if (nnddServerAddress != null && nnddServerAddress.length > 0 && nnddServerPort > 0)
			{
				nnddDownloader._isEnableGetVideoFromOtherNNDDServer = true;
				nnddDownloader._otherNNDDServerAddress = nnddServerAddress;
				nnddDownloader._otherNNDDServerPort = nnddServerPort;
			}
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_COMPLETE, downloadProcessCompleteListener);
			
			nnddDownloader.addEventListener(NNDDDownloader.COMMENT_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.GETFLV_API_ACCESS_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.ICHIBA_INFO_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.LOGIN_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.NICOWARI_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.OWNER_COMMENT_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_IMG_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_INFO_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.VIDEO_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.WATCH_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.REMOTE_NNDD_SERVER_ACCESS_SUCCESS, getProgressListener);
			
			nnddDownloader.addEventListener(NNDDDownloader.COMMENT_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.GETFLV_API_ACCESS_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.ICHIBA_INFO_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.LOGIN_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.NICOWARI_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.OWNER_COMMENT_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_IMG_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_INFO_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.VIDEO_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.WATCH_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_COMPLETE, getProgressListener);
			
			nnddDownloader.addEventListener(NNDDDownloader.COMMENT_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.GETFLV_API_ACCESS_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.ICHIBA_INFO_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.LOGIN_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.NICOWARI_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.OWNER_COMMENT_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_IMG_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_INFO_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.VIDEO_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.WATCH_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_ERROR, streamingPlayFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_CANCELD, streamingPlayFailListener);
			nnddDownloader.requestDownloadForStreaming(UserManager.instance.user, 
				UserManager.instance.password, 
				videoId, 
				LibraryManager.instance.tempDir, 
				false,
				false);
		}
		
		/**
		 * 動画取得成功時に呼ばれるリスナ
		 * @param event
		 * 
		 */
		protected function downloadProcessCompleteListener(event:Event):void
		{
			
			videoPlayView.title = (event.target as NNDDDownloader).nicoVideoName;
			
			videoPlayView.label_downloadStatus.visible = false;
			videoPlayView.label_downloadStatus.text = null;
			
			var url:String = (event.target as NNDDDownloader).videoUrl;
			
			
			// 再生領域の生成
			if (VideoType.VIDEO_TYPE_FLV == (event.target as NNDDDownloader).videoType 
					|| VideoType.VIDEO_TYPE_MP4 == (event.target as NNDDDownloader).videoType)
			{
				initVideo(url);
			}
			else if (VideoType.VIDEO_TYPE_SWF == (event.target as NNDDDownloader).videoType)
			{
				initSwf(url);
			}
			
		}
		
		protected function initVideo(url:String):void
		{
			var video:Video = new Video();
			
			var connection:NetConnection = new NetConnection();
			connection.connect(null);
			
			var netStream:NetStream = new NetStream(connection);
			netStream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorEventListener);
			
			
			video.attachNetStream(netStream);
			netStream.play(url);
			
			this.netStream = netStream;
			this.video = video;
			
			try {
				videoPlayView.videoPlayArea.removeChildAt(0);
			}catch (e:RangeError)
			{
			}
			
			videoPlayView.videoPlayArea.addChild(video);
		}
		
		protected function asyncErrorEventListener(event:AsyncErrorEvent):void
		{
			trace(event);
		}
		
		protected function initSwf(url:String):void
		{
			try {
				videoPlayView.videoPlayArea.removeChildAt(0);
			}catch (e:RangeError)
			{
			}
		}
		
		/**
		 * 動画の再生および動画のDL処理を停止します。
		 * 
		 */
		public function stop():void
		{
			if (nnddDownloader != null)
			{
				nnddDownloader.close(false, false);
				nnddDownloader = null;
			}
			
			if (video != null)
			{
				video.attachNetStream(null);
				netStream = null;
			}
			else if(swfLoader != null)
			{
				
			}
			
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public function getProgressListener(event:Event):void{
			var status:String = null;
			if(event.type == NNDDDownloader.LOGIN_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.WATCH_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.GETFLV_API_ACCESS_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.COMMENT_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.OWNER_COMMENT_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.NICOWARI_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.THUMB_INFO_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.THUMB_IMG_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.ICHIBA_INFO_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.VIDEO_GET_SUCCESS){
				status = "成功";
			}
			
			if(event.type == NNDDDownloader.LOGIN_START){
				status = "ログインしています...";
			}else if(event.type == NNDDDownloader.WATCH_START){
				status = "動画ページにアクセスしています...";
			}else if(event.type == NNDDDownloader.GETFLV_API_ACCESS_START){
				status = "動画取得APIにアクセスしています...";
			}else if(event.type == NNDDDownloader.COMMENT_GET_START){
				status = "コメントを取得しています...";
			}else if(event.type == NNDDDownloader.OWNER_COMMENT_GET_START){
				status = "投稿者コメントを取得しています...";
			}else if(event.type == NNDDDownloader.NICOWARI_GET_START){
				status = "ニコ割を取得しています...";
			}else if(event.type == NNDDDownloader.THUMB_INFO_GET_START){
				status = "サムネイル情報を取得しています...";
			}else if(event.type == NNDDDownloader.THUMB_IMG_GET_START){
				status = "サムネイル画像を取得しています...";
			}else if(event.type == NNDDDownloader.ICHIBA_INFO_GET_START){
				status = "市場情報を取得しています...";
			}else if(event.type == NNDDDownloader.VIDEO_GET_START){
				status = "動画を取得しています...";
			}
			
			if (event.type == NNDDDownloader.REMOTE_NNDD_SERVER_ACCESS_SUCCESS)
			{
				status = "代替URLを使用(" + (event.currentTarget as NNDDDownloader).nnddServerVideoUrl + ")";
			} 
			
			trace(status);
			if ("成功" == status)
			{
				videoPlayView.label_downloadStatus.text = videoPlayView.label_downloadStatus.text + " " + status;
			}
			else
			{
				videoPlayView.label_downloadStatus.text = videoPlayView.label_downloadStatus.text + "\n\t" + status;
			}
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public function streamingPlayFailListener(event:Event):void{
			var tempStr:String = videoPlayView.label_downloadStatus.text;
			if(event.type == NNDDDownloader.DOWNLOAD_PROCESS_CANCELD){
				videoPlayView.label_downloadStatus.text = tempStr + "\n\nアクセスをキャンセルしました。";
				LogManager.instance.addLog("***ストリーミング再生をキャンセル***");
			}else if(event.type == NNDDDownloader.DOWNLOAD_PROCESS_ERROR){
				videoPlayView.label_downloadStatus.text = tempStr + "\n\n動画を取得できませんでした。\n" + (event as IOErrorEvent).text + "\n" + event;
				LogManager.instance.addLog(NNDDDownloader.DOWNLOAD_PROCESS_ERROR + ":" + event + ":" + (event as IOErrorEvent).text);
				LogManager.instance.addLog("***ストリーミング再生に失敗***");
			}
			stop();
			
			nnddDownloader == null;
			
		}
		
		/**
		 * 取得失敗系リスナー
		 * @param event
		 * 
		 */
		public function getFailListener(event:IOErrorEvent):void{
			var status:String = "";
			if(event.type == NNDDDownloader.LOGIN_FAIL){
				status = "ログイン失敗";
			}else if(event.type == NNDDDownloader.WATCH_FAIL){
				status = "動画ページアクセス失敗";
			}else if(event.type == NNDDDownloader.GETFLV_API_ACCESS_FAIL){
				status = "APIアクセス失敗";
			}else if(event.type == NNDDDownloader.COMMENT_GET_FAIL){
				status = "コメント取得失敗";
			}else if(event.type == NNDDDownloader.OWNER_COMMENT_GET_FAIL){
				status = "投稿者コメント取得失敗";
			}else if(event.type == NNDDDownloader.NICOWARI_GET_FAIL){
				status = "ニコ割取得失敗";
			}else if(event.type == NNDDDownloader.THUMB_INFO_GET_FAIL){
				status = "サムネイル情報取得失敗";
			}else if(event.type == NNDDDownloader.THUMB_IMG_GET_FAIL){
				status = "サムネイル画像取得失敗";
			}else if(event.type == NNDDDownloader.ICHIBA_INFO_GET_FAIL){
				status = "市場情報取得失敗";
			}else if(event.type == NNDDDownloader.VIDEO_GET_FAIL){
				status = "動画取得失敗";
			} 
			
			LogManager.instance.addLog("\t" + status + ":" + event.type + ":" + event.text);
			videoPlayView.label_downloadStatus.text =  videoPlayView.label_downloadStatus.text + "\n\t" + status;
		}
		
	}
}