/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.bootstrap;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Add;
import com.funambol.framework.core.CmdID;
import com.funambol.framework.core.Constants;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.SessionID;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.dm.bootstrap.BasicAccountInfo;
import com.funambol.framework.core.dm.ddf.MgmtTree;
import com.funambol.framework.core.dm.ddf.Node;
import com.funambol.framework.engine.dm.Util;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.WBXMLTools;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class DMBootstrapMessageBuilder {
    public static final String ACC_APP_ID = "AppID";
    public static final String ACC_SERVER_ID = "ServerID";
    public static final String ACC_NAME = "Name";
    public static final String ACC_AUTH_PREF = "AAuthPref";
    public static final String APP_ADDR = "AppAddr";
    public static final String APP_AUTH = "AppAuth";
    public static final String ACC_SERVER_ADDR = "Addr";
    public static final String ACC_SERVER_ADDR_TYPE = "AddrType";
    public static final String SERVER_PORT = "Port";
    public static final String ACC_SERVER_PORT_NBR = "PortNbr";
    public static final String ACC_AUTH_NAME = "AAuthName";
    public static final String ACC_AUTH_LEVEL = "AAuthLevel";
    public static final String ACC_AUTH_TYPE = "AAuthType";
    public static final String ACC_AUTH_SECRET = "AAuthSecret";
    public static final String ACC_AUTH_DATA = "AAuthData";
    public static final String ACC_CLIENT = "Client";
    public static final String ACC_SERVER = "Server";
    public static final String AUTH_BASIC = "BASIC";
    public static final String AUTH_MD5 = "DIGEST";
    public static final String AUTH_HMAC = "HMAC";
    private static final Logger log = Logger.getLogger((String)DMBootstrapMessageBuilder.class.getName());

    public byte[] buildMessage(BasicAccountInfo basicAccountInfo, MgmtTree bootstrapTree) throws NotificationException {
        MgmtTree baiTree = this.createAccountMgmtTree(basicAccountInfo);
        bootstrapTree = DMBootstrapMessageBuilder.mergeMgmtTrees(bootstrapTree, baiTree);
        SyncML syncMLPlainBootstrapMessage = this.getSyncMLBootstrapMessage(bootstrapTree, basicAccountInfo);
        byte[] message = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IMarshallingContext c = f.createMarshallingContext();
            c.setIndent(0);
            c.marshalDocument((Object)syncMLPlainBootstrapMessage, "UTF-8", null, (OutputStream)bout);
            String inputXml = new String(bout.toByteArray());
            inputXml = this.metInfNamespaceHandler(inputXml);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("DMBootstrapMessage - xml: " + inputXml));
            }
            message = WBXMLTools.toWBXML((String)inputXml, (String)Constants.DTD_1_2.getValue());
        }
        catch (Exception ex) {
            throw new NotificationException("Error during xml to wbxml transformation", (Throwable)ex);
        }
        return message;
    }

    private SyncML getSyncMLBootstrapMessage(MgmtTree tree, BasicAccountInfo basicAccountInfo) throws NotificationException {
        SyncML syncMLBootstrapMessage = null;
        SyncHdr syncHdrMessage = null;
        SyncBody syncBodyMessage = null;
        try {
            URL url = null;
            URL newUrlWithPort = null;
            try {
                url = new URL(basicAccountInfo.getServerAddress());
                String hostName = url.getHost();
                String protocol = url.getProtocol();
                String file = url.getFile();
                newUrlWithPort = new URL(protocol, hostName, basicAccountInfo.getServerPort(), file);
            }
            catch (MalformedURLException e) {
                throw new NotificationException("Error creating the serverURI", (Throwable)e);
            }
            syncHdrMessage = new SyncHdr(Constants.DTD_1_2, Constants.SYNCML_DM_1_2, new SessionID("0"), "0", new Target(basicAccountInfo.getDeviceId()), new Source(newUrlWithPort.toExternalForm()), null, false, null, null);
            Item item = Util.mgmtTree2item((String)"./Inbox", (MgmtTree)tree, (boolean)true, (String)"application/vnd.syncml.dm+wbxml");
            Add addCommand = new Add(new CmdID(1L), false, null, null, new Item[]{item});
            syncBodyMessage = new SyncBody(new AbstractCommand[]{addCommand}, true);
            syncMLBootstrapMessage = new SyncML(syncHdrMessage, syncBodyMessage);
        }
        catch (RepresentationException ex) {
            throw new NotificationException("Error during creation of the SyncML message", (Throwable)ex);
        }
        return syncMLBootstrapMessage;
    }

    private String metInfNamespaceHandler(String msg) {
        int s = 0;
        int e = 0;
        StringBuffer response = new StringBuffer();
        while ((e = msg.indexOf("<Meta", s)) >= 0) {
            response = response.append(msg.substring(s, e));
            int a = msg.indexOf("</Meta>", e);
            String meta = msg.substring(e, a);
            meta = meta.replaceAll("<Type>", "<Type xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Format>", "<Format xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Mark>", "<Mark xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Size>", "<Size xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Anchor>", "<Anchor xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Version>", "<Version xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<NextNonce>", "<NextNonce xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<MaxMsgSize>", "<MaxMsgSize xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<MaxObjSize>", "<MaxObjSize xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<EMI>", "<EMI xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Mem>", "<Mem xmlns='syncml:metinf'>");
            s = a + 7;
            response.append(meta).append("</Meta>");
        }
        return response.append(msg.substring(s, msg.length())).toString();
    }

    private MgmtTree createAccountMgmtTree(BasicAccountInfo basicAccountInfo) {
        MgmtTree mgmtTree = new MgmtTree();
        mgmtTree.setVerDTD(Constants.DTD_1_2);
        String authentication = basicAccountInfo.getAuthPref();
        String authType = "";
        if ("syncml:auth-basic".equalsIgnoreCase(authentication)) {
            authType = AUTH_BASIC;
        } else if ("syncml:auth-md5".equalsIgnoreCase(authentication)) {
            authType = AUTH_MD5;
        } else if ("syncml:auth-MAC".equalsIgnoreCase(authentication)) {
            authType = AUTH_HMAC;
        }
        Node dmAcc = new Node(basicAccountInfo.getAccountName(), null, null, "node", null);
        dmAcc.setType("org.openmobilealliance/1.0/w7");
        Node appId = new Node(ACC_APP_ID, null, null, "chr", "org.openmobilealliance/1.0/w7");
        dmAcc.addNode(appId);
        Node serverId = new Node(ACC_SERVER_ID, null, null, "chr", basicAccountInfo.getServerId());
        dmAcc.addNode(serverId);
        Node name = new Node(ACC_NAME, null, null, "chr", basicAccountInfo.getAccountName());
        dmAcc.addNode(name);
        Node appAddress = new Node(APP_ADDR, null, null, "node", null);
        dmAcc.addNode(appAddress);
        Node mgmtServerName = new Node(basicAccountInfo.getAccountName(), null, null, "node", null);
        appAddress.addNode(mgmtServerName);
        Node addr = new Node(ACC_SERVER_ADDR, null, null, "chr", basicAccountInfo.getServerAddress());
        mgmtServerName.addNode(addr);
        Node addressType = new Node(ACC_SERVER_ADDR_TYPE, null, null, "chr", String.valueOf(basicAccountInfo.getAddressType()));
        mgmtServerName.addNode(addressType);
        Node serverPort = new Node(SERVER_PORT, null, null, "node", null);
        mgmtServerName.addNode(serverPort);
        Node portNbr = new Node(ACC_SERVER_PORT_NBR, null, null, "int", String.valueOf(basicAccountInfo.getServerPort()));
        serverPort.addNode(portNbr);
        Node authPref = new Node(ACC_AUTH_PREF, null, null, "chr", authType);
        dmAcc.addNode(authPref);
        Node appAuth = new Node(APP_AUTH, null, null, "node", null);
        dmAcc.addNode(appAuth);
        Node authClient = new Node(ACC_CLIENT, null, null, "node", null);
        dmAcc.addNode(authClient);
        Node cAuthType = new Node(ACC_AUTH_TYPE, null, null, "chr", authType);
        authClient.addNode(cAuthType);
        Node cAuthName = new Node(ACC_AUTH_NAME, null, null, "chr", basicAccountInfo.getServerAddress());
        authClient.addNode(cAuthName);
        Node cAuthSecret = new Node(ACC_AUTH_SECRET, null, null, "chr", basicAccountInfo.getServerPassword());
        authClient.addNode(cAuthSecret);
        Node cAuthData = new Node(ACC_AUTH_DATA, null, null, "chr", new String(Base64.encode((byte[])basicAccountInfo.getServerNonce())));
        authClient.addNode(cAuthData);
        Node cAuthLevel = new Node(ACC_AUTH_LEVEL, null, null, "chr", "CLCRED");
        authClient.addNode(cAuthLevel);
        Node authServer = new Node(ACC_CLIENT, null, null, "node", null);
        dmAcc.addNode(authServer);
        Node sAuthType = new Node(ACC_AUTH_TYPE, null, null, "chr", authType);
        authServer.addNode(sAuthType);
        Node sAuthName = new Node(ACC_AUTH_NAME, null, null, "chr", basicAccountInfo.getServerAddress());
        authServer.addNode(sAuthName);
        Node sAuthSecret = new Node(ACC_AUTH_SECRET, null, null, "chr", basicAccountInfo.getServerPassword());
        authServer.addNode(sAuthSecret);
        Node sAuthData = new Node(ACC_AUTH_DATA, null, null, "chr", new String(Base64.encode((byte[])basicAccountInfo.getServerNonce())));
        authServer.addNode(sAuthData);
        Node sAuthLevel = new Node(ACC_AUTH_LEVEL, null, null, "chr", "SRVCRED");
        authServer.addNode(sAuthLevel);
        mgmtTree.addNode(dmAcc);
        return mgmtTree;
    }

    public static MgmtTree mergeMgmtTrees(MgmtTree firstTree, MgmtTree secondTree) {
        if (firstTree == null) {
            return secondTree;
        }
        if (secondTree == null) {
            return firstTree;
        }
        List nodes = Util.mergeSubNodes((ArrayList)firstTree.getTreeNodes(), (ArrayList)secondTree.getTreeNodes());
        firstTree.setTreeNodes((ArrayList)nodes);
        return firstTree;
    }
}

