/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.NextNonce;
import com.funambol.framework.core.Replace;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.core.dm.ddf.DevInfo;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.protocol.SyncPackage;
import com.funambol.framework.protocol.v11.Errors;
import com.funambol.framework.protocol.v11.InitializationRequirements;
import com.funambol.framework.tools.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ManagementInitialization
extends SyncPackage
implements Errors {
    private AbstractCommand[] clientCommands = null;
    private Alert clientAlert = null;
    private int authorizedStatusCode = -1;
    private DevInfo devInfo = null;
    AbstractCommand[] managementCommands;
    private Chal clientChal = null;
    private Cred serverCredentials;
    private String serverAuthType = null;
    private String supportedAuthType = null;
    private String clientAuthType = null;
    private NextNonce nextNonce = null;
    private HashMap<String, Integer> commandStatus = new HashMap();

    public AbstractCommand[] getClientCommands() {
        return this.clientCommands;
    }

    public void addClientCommand(AbstractCommand[] command) {
        AbstractCommand[] obj = (AbstractCommand[])ArrayUtils.mergeArrays(this.clientCommands, command, AbstractCommand.class);
        this.clientCommands = obj;
    }

    public Alert getClientAlert() {
        return this.clientAlert;
    }

    public void setAuthorizedStatusCode(int authorizedStatusCode) {
        this.authorizedStatusCode = authorizedStatusCode;
    }

    public DevInfo getDevInfo() {
        return this.devInfo;
    }

    public void setManagementCommands(AbstractCommand[] commands) {
        this.managementCommands = commands;
    }

    public AbstractCommand[] getManagementCommands() {
        return this.managementCommands;
    }

    public Chal getClientChal() {
        return this.clientChal;
    }

    public void setServerCredentials(Cred serverCredentials) {
        this.serverCredentials = serverCredentials;
    }

    public Cred getServerCredentials() {
        return this.serverCredentials;
    }

    public void setServerAuthType(String authType) {
        this.serverAuthType = authType;
    }

    public void setSupportedAuthType(String supportedAuthType) {
        this.supportedAuthType = supportedAuthType;
    }

    public void setClientAuthType(String authType) {
        this.clientAuthType = authType;
    }

    public void setNextNonce(NextNonce nextNonce) {
        this.nextNonce = nextNonce;
    }

    public void setStatusCodeForCommand(AbstractCommand cmd, int statusCode) {
        this.setStatusCodeForCommand(cmd.getCmdID().getCmdID(), statusCode);
    }

    public void setStatusCodeForCommand(String cmdId, int statusCode) {
        this.commandStatus.put(cmdId, statusCode);
    }

    public int getStatusCodeForCommand(AbstractCommand cmd, int defaultCode) {
        String cmdId = cmd.getCmdID().getCmdID();
        return this.getStatusCodeForCommand(cmdId, defaultCode);
    }

    public int getStatusCodeForCommand(String cmdId, int defaultCode) {
        Integer statusCode = this.commandStatus.get(cmdId);
        return statusCode == null ? defaultCode : statusCode;
    }

    public ManagementInitialization(SyncHdr syncHeader, SyncBody syncBody) throws ProtocolException {
        super(syncHeader, syncBody);
        this.checkRequirements();
    }

    @Override
    public void checkHeaderRequirements() throws ProtocolException {
        InitializationRequirements.checkDTDVersion(this.syncHeader.getVerDTD());
        InitializationRequirements.checkProtocolVersion(this.syncHeader.getVerProto());
        InitializationRequirements.checkSessionId(this.syncHeader.getSessionID());
        InitializationRequirements.checkMessageId(this.syncHeader.getMsgID());
        InitializationRequirements.checkTarget(this.syncHeader.getTarget());
        InitializationRequirements.checkSource(this.syncHeader.getSource());
    }

    @Override
    public void checkBodyRequirements() throws ProtocolException {
        AbstractCommand[] allClientCommands = this.syncBody.getCommands().toArray(new AbstractCommand[0]);
        ArrayList<AbstractCommand> alertList = ProtocolUtil.filterCommands(allClientCommands, Alert.class);
        int size = alertList.size();
        for (int i = 0; i < size; ++i) {
            this.clientAlert = (Alert)alertList.get(i);
            if (this.clientAlert.getData() != 1223) continue;
            this.setFlag(7);
            break;
        }
        if (this.isFinal()) {
            ArrayList<AbstractCommand> replaceCommands = ProtocolUtil.filterCommands(allClientCommands, Replace.class);
            if (replaceCommands.isEmpty()) {
                throw new ProtocolException("Missing required SyncBody/Replace");
            }
            InitializationRequirements.checkDeviceInfo((Replace)replaceCommands.get(0));
            this.devInfo = ProtocolUtil.devInfoFromReplace((Replace)replaceCommands.get(0));
        }
        this.clientCommands = allClientCommands;
    }

    @Override
    public SyncML getResponse(String msgId) throws ProtocolException {
        ArrayList<AbstractCommand> responseCommandList = new ArrayList<AbstractCommand>();
        ArrayList<AbstractCommand> clientCommandList = new ArrayList<AbstractCommand>(Arrays.asList(this.clientCommands));
        if (!this.syncHeader.isNoResp()) {
            TargetRef[] targetRefs = new TargetRef[]{new TargetRef(this.syncHeader.getTarget().getLocURI())};
            SourceRef[] sourceRefs = new SourceRef[]{new SourceRef(this.syncHeader.getSource().getLocURI())};
            Chal chal = null;
            if (!this.isFlag(10)) {
                switch (this.authorizedStatusCode) {
                    case 200: {
                        if (!this.clientAuthType.equalsIgnoreCase("syncml:auth-MAC")) break;
                        chal = Chal.getHMACChal();
                        chal.setNextNonce(this.nextNonce);
                        break;
                    }
                    case 212: {
                        if (this.clientAuthType.equalsIgnoreCase("syncml:auth-md5")) {
                            chal = Chal.getMD5Chal();
                            chal.setNextNonce(this.nextNonce);
                            break;
                        }
                        if (!this.clientAuthType.equalsIgnoreCase("syncml:auth-MAC")) break;
                        chal = Chal.getHMACChal();
                        chal.setNextNonce(this.nextNonce);
                        break;
                    }
                    case 401: {
                        if (this.clientAuthType != null && this.supportedAuthType.indexOf(this.clientAuthType) != -1) {
                            if (this.clientAuthType.equalsIgnoreCase("syncml:auth-basic")) {
                                chal = Chal.getBasicChal();
                                break;
                            }
                            if (this.clientAuthType.equalsIgnoreCase("syncml:auth-clear")) {
                                chal = Chal.getClearChal();
                                break;
                            }
                            if (this.clientAuthType.equalsIgnoreCase("syncml:auth-md5")) {
                                chal = Chal.getMD5Chal();
                                chal.setNextNonce(this.nextNonce);
                                break;
                            }
                            if (!this.clientAuthType.equalsIgnoreCase("syncml:auth-MAC")) break;
                            chal = Chal.getHMACChal();
                            chal.setNextNonce(this.nextNonce);
                            break;
                        }
                    }
                    case 407: {
                        if (this.serverAuthType.equalsIgnoreCase("syncml:auth-basic")) {
                            chal = Chal.getBasicChal();
                            break;
                        }
                        if (this.serverAuthType.equalsIgnoreCase("syncml:auth-clear")) {
                            chal = Chal.getClearChal();
                            break;
                        }
                        if (this.serverAuthType.equalsIgnoreCase("syncml:auth-md5")) {
                            chal = Chal.getMD5Chal();
                            chal.setNextNonce(this.nextNonce);
                            break;
                        }
                        if (!this.serverAuthType.equalsIgnoreCase("syncml:auth-MAC")) break;
                        chal = Chal.getHMACChal();
                        chal.setNextNonce(this.nextNonce);
                        break;
                    }
                }
            }
            Status statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), "0", "SyncHdr", targetRefs, sourceRefs, null, chal, new Data(String.valueOf(this.authorizedStatusCode)), new Item[0]);
            responseCommandList.add(statusCommand);
            int numClientCommand = clientCommandList.size();
            AbstractCommand command = null;
            for (int i = 0; i < numClientCommand; ++i) {
                command = clientCommandList.get(i);
                if (command.isNoResp() || command instanceof Status) continue;
                targetRefs = null;
                sourceRefs = null;
                String commandReference = command.getCmdID().getCmdID();
                int status = this.getStatusCodeForCommand(command, 200);
                Item[] items = new Item[]{};
                statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), commandReference, command.getName(), targetRefs, sourceRefs, null, null, new Data(status), items);
                responseCommandList.add(statusCommand);
            }
        }
        clientCommandList.clear();
        this.clientCommands = clientCommandList.toArray(new AbstractCommand[0]);
        if (!this.isFlag(7) && this.managementCommands != null) {
            for (int i = 0; i < this.managementCommands.length; ++i) {
                responseCommandList.add(this.managementCommands[i]);
            }
        }
        Target target = new Target(this.syncHeader.getSource().getLocURI(), this.syncHeader.getSource().getLocName());
        Source source = new Source(this.syncHeader.getTarget().getLocURI(), this.syncHeader.getTarget().getLocName());
        SyncHdr responseHeader = new SyncHdr(this.getDTDVersion(), this.getProtocolVersion(), this.syncHeader.getSessionID(), msgId, target, source, null, false, this.serverCredentials, this.syncHeader.getMeta());
        int size = responseCommandList.size();
        AbstractCommand[] aCommands = new AbstractCommand[size];
        for (int i = 0; i < size; ++i) {
            aCommands[i] = (AbstractCommand)responseCommandList.get(i);
            if (this.authorizedStatusCode == 212 || !(aCommands[i] instanceof Status)) continue;
            Status sc = (Status)aCommands[i];
            sc.setData(new Data(String.valueOf(this.authorizedStatusCode)));
        }
        SyncBody responseBody = new SyncBody(aCommands, this.isFlag(3));
        try {
            return new SyncML(responseHeader, responseBody);
        }
        catch (RepresentationException e) {
            throw new ProtocolException("Unexpected error", e);
        }
    }

    public void setRequest(SyncML request) {
        this.syncHeader = request.getSyncHdr();
        this.syncBody = request.getSyncBody();
    }

    public boolean isSessionAbortRequired() {
        return this.isFlag(7);
    }
}

