/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server.store;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.ConfigPersistentStoreException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.beans.BeanFactory;
import com.funambol.framework.tools.beans.BeanInitializationException;
import com.funambol.framework.tools.beans.LazyInitBean;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PersistentStoreManager
implements PersistentStore,
LazyInitBean,
Serializable {
    public static final String CONFIG_CLASS_LOADER = "class-loader";
    public static final String CONFIG_JNDI_DATA_SOURCE_NAME = "jndi-data-source-name";
    public static final String CONFIG_USERNAME = "username";
    public static final String CONFIG_PASSWORD = "password";
    private PersistentStore[] persistentStores = null;
    private String[] stores = null;
    private String jndiDataSourceName = null;
    private String username = null;
    private String password = null;

    public String[] getStores() {
        return this.stores;
    }

    public void setStores(String[] stores) {
        this.stores = stores;
    }

    public String getJndiDataSourceName() {
        return this.jndiDataSourceName;
    }

    public void setJndiDataSourceName(String jndiDataSourceName) {
        this.jndiDataSourceName = jndiDataSourceName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean store(Object o) throws PersistentStoreException {
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            if (!this.persistentStores[i].store(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean read(Object o) throws PersistentStoreException {
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            if (!this.persistentStores[i].read(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] read(Class objClass) throws PersistentStoreException {
        Object[] objs = null;
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            objs = this.persistentStores[i].read(objClass);
            if (objs == null) continue;
            return objs;
        }
        return null;
    }

    @Override
    public void configure(Map<String, Object> config) throws ConfigPersistentStoreException {
        int i;
        ClassLoader classLoader = (ClassLoader)config.get(CONFIG_CLASS_LOADER);
        if (classLoader == null) {
            classLoader = Configuration.getConfiguration().getClassLoader();
        }
        if (this.stores == null || this.stores.length == 0) {
            return;
        }
        this.persistentStores = new PersistentStore[this.stores.length];
        config = new HashMap<String, Object>(3);
        config.put(CONFIG_JNDI_DATA_SOURCE_NAME, this.jndiDataSourceName);
        config.put(CONFIG_USERNAME, this.username);
        config.put(CONFIG_PASSWORD, this.password);
        try {
            for (i = 0; this.stores != null && i < this.stores.length; ++i) {
                this.persistentStores[i] = (PersistentStore)BeanFactory.getBeanInstance(classLoader, this.stores[i]);
                this.persistentStores[i].configure(config);
            }
        }
        catch (Exception e) {
            throw new ConfigPersistentStoreException("Error in loading the persistent store " + this.stores[i] + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" - {");
        sb.append("jndiDataSourceName: ").append(this.jndiDataSourceName);
        sb.append("; stores: ");
        for (int i = 0; this.stores != null && i < this.stores.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.stores[i]);
        }
        return sb.toString();
    }

    @Override
    public boolean delete(Object o) throws PersistentStoreException {
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            if (!this.persistentStores[i].delete(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] read(Object o, Clause clause) throws PersistentStoreException {
        Object[] objs = null;
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            objs = this.persistentStores[i].read(o, clause);
            if (objs == null) continue;
            return objs;
        }
        return null;
    }

    @Override
    public boolean store(String id, Object o, String operation) throws PersistentStoreException {
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            if (!this.persistentStores[i].store(id, o, operation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int readCounter(String idSpace, int increment) throws PersistentStoreException {
        int counter = -1;
        for (int i = 0; this.persistentStores != null && i < this.persistentStores.length; ++i) {
            try {
                counter = this.persistentStores[i].readCounter(idSpace, increment);
                return counter;
            }
            catch (PersistentStoreException e) {
                if ("Function not supported".equals(e.getMessage())) continue;
                throw e;
            }
        }
        throw new PersistentStoreException("Function not supported");
    }

    @Override
    public void init() throws BeanInitializationException {
        try {
            this.configure(new HashMap<String, Object>());
        }
        catch (Exception e) {
            throw new BeanInitializationException(e.getMessage(), e.getCause());
        }
    }
}

