/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.tools;

import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.MD5;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;

public class SecurityTools {
    private static SecureRandom random = null;

    protected SecurityTools() {
    }

    public static String getRandomPassword() {
        byte[] nextNonce = new byte[16];
        random.nextBytes(nextNonce);
        for (int j = 0; j < nextNonce.length; ++j) {
            int i = nextNonce[j] & 0xFF;
            if (i >= 32 && i <= 128) continue;
            nextNonce[j] = (byte)(32 + i % 64);
        }
        return new String(Base64.encode(nextNonce));
    }

    public static String getHMACValue(String algorithm, byte[] msg, String username, String password, byte[] nonce, Logger log) throws NoSuchAlgorithmException {
        if (nonce == null) {
            nonce = new byte[]{};
        }
        if (log != null && log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Calculates mac with: \n\talgorith: " + algorithm + "\n\tmsg: " + msg + "\n\tusername: " + username + "\n\tpassword: " + password + "\n\tnonce: " + (nonce == null ? "is null" : new String(Base64.encode(nonce)))));
        }
        if (msg == null) {
            return null;
        }
        String cred = username + ":" + password;
        byte[] md5 = null;
        md5 = MD5.digest(cred.getBytes());
        byte[] digest = Base64.encode(md5);
        cred = new String(digest);
        return SecurityTools.getHMACValue(algorithm, msg, cred, nonce, log);
    }

    public static String getHMACValue(String algorithm, byte[] msg, String credential, byte[] nonce, Logger log) throws NoSuchAlgorithmException {
        if (log != null && log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Calculates mac with: \n\talgorith: " + algorithm + "\n\tmsg: " + msg + "\n\tcredential: " + credential + "\n\tnonce: " + (nonce == null ? "is null" : new String(Base64.encode(nonce)))));
        }
        if (msg == null) {
            return null;
        }
        MessageDigest md = null;
        md = MessageDigest.getInstance(algorithm);
        byte[] digestDataMessage = null;
        byte[] b64DigestDataMessage = null;
        byte[] digest = null;
        digestDataMessage = md.digest(msg);
        b64DigestDataMessage = Base64.encode(digestDataMessage);
        md.reset();
        byte[] credentialBytes = null;
        credentialBytes = credential != null ? credential.getBytes() : new byte[]{};
        if (nonce == null) {
            nonce = new byte[]{};
        }
        byte[] buf = new byte[credentialBytes.length + 2 + nonce.length + b64DigestDataMessage.length];
        System.arraycopy(credentialBytes, 0, buf, 0, credentialBytes.length);
        buf[credentialBytes.length] = 58;
        System.arraycopy(nonce, 0, buf, credentialBytes.length + 1, nonce.length);
        buf[credentialBytes.length + nonce.length + 1] = 58;
        System.arraycopy(b64DigestDataMessage, 0, buf, credentialBytes.length + nonce.length + 2, b64DigestDataMessage.length);
        digest = md.digest(buf);
        String mac = new String(Base64.encode(digest));
        if (log != null && log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("HMAC: " + mac));
        }
        return mac;
    }

    public static byte[] computeHmacSha1(byte[] bKey, byte[] message) throws GeneralSecurityException {
        String algorithm = "HmacSha1";
        byte[] digest = null;
        SecretKeySpec key = new SecretKeySpec(bKey, algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(key);
        digest = mac.doFinal(message);
        return digest;
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

