Imports System.Net
Imports System.Collections.Generic
Imports System.Collections.Specialized
Imports System.IO
Imports System.Text
Imports System.Security

Public Class HttpConnectionOAuth
    Inherits HttpConnection

    '''<summary>
    '''OAuthoauth_timestampZopti1970/1/1 00:00:00j
    '''</summary>
    Private Shared ReadOnly UnixEpoch As New DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Unspecified)

    '''<summary>
    '''OAuthoauth_nonceZopNX
    '''</summary>
    Private Shared ReadOnly NonceRandom As New Random

    '''<summary>
    '''OAuth̔F؃vZX̂ݎgp郊NGXgg[N
    '''</summary>
    Private Shared requestToken As String

    '''<summary>
    '''OAuth̃ANZXg[NBi\i[U[̉\͂jB
    '''</summary>
    Private Shared token As String = ""

    '''<summary>
    '''OAuth̏쐬p閧ANZXg[NBi\i[U[̉\͂jB
    '''</summary>
    Private Shared tokenSecret As String = ""

    '''<summary>
    '''OAuth̃RV[}[
    '''</summary>
    Private Const ConsumerKey As String = "EANjQEa5LokuVld682tTDA"

    '''<summary>
    '''OAuth̏쐬p閧RV[}[f[^
    '''</summary>
    Private Const ConsumerSecret As String = "zXfwkzmuO6FcHtoikleV3EVgdh5vVAs6ft6ZxtYTYM"

    '''<summary>
    '''OAuth̃NGXgg[N擾URI
    '''</summary>
    Private Const RequestTokenUrl As String = "http://twitter.com/oauth/request_token"

    '''<summary>
    '''OAuth̃[U[Fؗpy[WURI
    '''</summary>
    '''<remarks>
    '''NGuoauth_token=NGXgg[NvtāAURIuEUŊJB[U[FsPINR[h\B
    '''</remarks>
    Private Const AuthorizeUrl As String = "http://twitter.com/oauth/authorize"

    '''<summary>
    '''OAuth̃ANZXg[N擾URI
    '''</summary>
    Private Const AccessTokenUrl As String = "http://twitter.com/oauth/access_token"

    '''<summary>
    '''HTTPʐMăRec擾iRecj
    '''</summary>
    '''<remarks>
    '''ʐM^CAEgȂWebExceptionnhĂȂ߁AĂяoŏKvB
    '''^CAEgw⃌X|Xwb_擾͏ȗĂB
    '''X|X̃{fBXg[𕶎ɕϊcontentɊi[Ė߂BGR[h͖w
    '''</remarks>
    '''<param name="method">HTTP̃\bh</param>
    '''<param name="requestUri">URI</param>
    '''<param name="param">key=valueɓWJāANGiGETjE{fBiPOSTjɕt鑗M</param>
    '''<param name="content">[IN/OUT]HTTPX|X̃{fBf[^ԋppBĂяoŏKv</param>
    '''<param name="headerInfo">[IN/OUT]HTTP̃wb_</param>
    '''<returns>ʐMʂHttpStatusCode</returns>
    Protected Function GetContent(ByVal method As RequestMethod, _
            ByVal requestUri As Uri, _
            ByVal param As SortedList(Of String, String), _
            ByRef content As String, _
            ByVal headerInfo As Dictionary(Of String, String)) As HttpStatusCode
        'contentCX^XĂ邩`FbN
        If content Is Nothing Then Throw New ArgumentNullException("content")
        'F؍ς`FbN
        If String.IsNullOrEmpty(token) Then Throw New Exception("Sequence error. (Token is blank.)")

        Dim webReq As HttpWebRequest = CreateRequest(method, _
                                                    requestUri, _
                                                    param, _
                                                    False)
        'OAuthF؃wb_t
        AppendOAuthInfo(webReq, param, token, tokenSecret)

        Return GetResponse(webReq, content, headerInfo, False)
    End Function

#Region "F؏"
    Protected Function AuthorizeAccount() As Boolean
        Dim authUri As Uri = GetAuthorizePageUri()
        If authUri Is Nothing Then Return False
        System.Diagnostics.Process.Start(authUri.PathAndQuery)
        Dim inputForm As New InputTabName
        inputForm.FormTitle = "Input PIN code"
        inputForm.FormDescription = "Input the PIN code shown in the browser after you accept OAuth request."
        If inputForm.ShowDialog() = DialogResult.OK AndAlso Not String.IsNullOrEmpty(inputForm.TabName) Then
            Return GetAccessToken(inputForm.TabName)
        Else
            Return False
        End If
    End Function

    Private Shared Function GetAuthorizePageUri() As Uri
        Const tokenKey As String = "oauth_token"
        requestToken = ""
        Dim reqTokenData As NameValueCollection = GetOAuthToken(New Uri(RequestTokenUrl), "")
        If reqTokenData IsNot Nothing Then
            requestToken = reqTokenData.Item(tokenKey)
            Dim ub As New UriBuilder(AuthorizeUrl)
            ub.Query = String.Format("{0}={1}", tokenKey, requestToken)
            Return ub.Uri
        Else
            Return Nothing
        End If
    End Function

    Private Shared Function GetAccessToken(ByVal pinCode As String) As Boolean
        If String.IsNullOrEmpty(requestToken) Then Throw New Exception("Sequence error.(requestToken is blank)")

        Dim accessTokenData As NameValueCollection = GetOAuthToken(New Uri(AccessTokenUrl), pinCode)

        If accessTokenData IsNot Nothing Then
            Token = accessTokenData.Item("oauth_token")
            TokenSecret = accessTokenData.Item("oauth_token_secret")
            If Token = "" Then Return False
            Return True
        Else
            Return False
        End If
    End Function

    Private Shared Function GetOAuthToken(ByVal requestUri As Uri, ByVal pinCode As String) As NameValueCollection
        Dim webReq As HttpWebRequest = Nothing
        If String.IsNullOrEmpty(pinCode) Then
            webReq = HttpConnection.CreateRequest(RequestMethod.ReqGet, requestUri, Nothing, False)
        Else
            webReq = HttpConnection.CreateRequest(RequestMethod.ReqPost, requestUri, Nothing, False)
        End If
        Dim query As New SortedList(Of String, String)
        If Not String.IsNullOrEmpty(pinCode) Then query.Add("oauth_verifier", pinCode)
        AppendOAuthInfo(webReq, query, requestToken, "")
        Try
            Dim status As HttpStatusCode
            Dim contentText As String = ""
            status = HttpConnection.GetResponse(webReq, contentText, Nothing, False)
            If status = HttpStatusCode.OK Then
                Return ParseQueryString(contentText)
            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region

#Region "OAuthFؗpwb_쐬Et"
    Private Shared Sub AppendOAuthInfo(ByVal webRequest As HttpWebRequest, _
                                        ByVal query As SortedList(Of String, String), _
                                        ByVal token As String, _
                                        ByVal tokenSecret As String)
        Dim parameter As New SortedList(Of String, String)
        parameter.Add("oauth_consumer_key", ConsumerKey)
        parameter.Add("oauth_signature_method", "HMAC-SHA1")
        parameter.Add("oauth_timestamp", GetTimestamp())
        parameter.Add("oauth_nonce", GetNonce())
        parameter.Add("oauth_version", "1.0")
        If Not String.IsNullOrEmpty(token) Then parameter.Add("oauth_token", token)
        If query IsNot Nothing Then
            For Each item As KeyValuePair(Of String, String) In query
                parameter.Add(item.Key, item.Value)
            Next
        End If
        parameter.Add("oauth_signature", CreateSignature(tokenSecret, webRequest.Method, webRequest.RequestUri, parameter))
        Dim sb As New StringBuilder("OAuth ")
        For Each item As KeyValuePair(Of String, String) In parameter
            If item.Key.StartsWith("oauth_") Then
                sb.AppendFormat("{0}=""{1}"",", item.Key, UrlEncode(item.Value))
            End If
        Next
        webRequest.Headers.Add(HttpRequestHeader.Authorization, sb.ToString)
    End Sub

    Private Shared Function CreateSignature(ByVal tokenSecret As String, _
                                            ByVal method As String, _
                                            ByVal uri As Uri, _
                                            ByVal parameter As SortedList(Of String, String) _
                                        ) As String
        Dim paramString As String = CreateQueryString(parameter)
        Dim url As String = String.Format("{0}://{1}{2}", uri.Scheme, uri.Host, uri.AbsolutePath)
        Dim signatureBase As String = String.Format("{0}&{1}&{2}", method, UrlEncode(url), UrlEncode(paramString))
        Dim key As String = UrlEncode(ConsumerSecret) + "&"
        If Not String.IsNullOrEmpty(tokenSecret) Then key += UrlEncode(tokenSecret)
        Dim hmac As New Cryptography.HMACSHA1(Encoding.ASCII.GetBytes(key))
        Dim hash As Byte() = hmac.ComputeHash(Encoding.ASCII.GetBytes(signatureBase))
        Return Convert.ToBase64String(hash)
    End Function

    Private Shared Function GetTimestamp() As String
        Return Convert.ToInt64((DateTime.UtcNow - UnixEpoch).TotalSeconds).ToString()
    End Function

    Private Shared Function GetNonce() As String
        Return NonceRandom.Next(123400, 9999999).ToString()
    End Function
#End Region

    Protected Shared Sub Initialize(ByVal token As String, ByVal tokenSecret As String)
        HttpConnectionOAuth.Token = token
        HttpConnectionOAuth.TokenSecret = tokenSecret
    End Sub
End Class
