﻿// OpenTween - Client of Twitter
// Copyright (c) 2015 takke (@takke) <http://takke.jp/>
// All rights reserved.
//
// This file is part of OpenTween.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3 of the License, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program. If not, see <http://www.gnu.org/licenses/>, or write to
// the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
// Boston, MA 02110-1301, USA.
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace OpenTween
{
    /// <summary>
    /// ツイート内の絵文字を img タグに書き換えるクラス
    /// </summary>
    public static class EmojiFormatter
    {
        private static HashSet<string> emojiSet = new HashSet<string>()
        {
            "1f004",
            "1f0cf",
            "1f170",
            "1f171",
            "1f17e",
            "1f17f",
            "1f18e",
            "1f191",
            "1f192",
            "1f193",
            "1f194",
            "1f195",
            "1f196",
            "1f197",
            "1f198",
            "1f199",
            "1f19a",
            "1f1e6",
            "1f1e7",
            "1f1e8",
            "1f1e8-1f1f3",
            "1f1e9",
            "1f1e9-1f1ea",
            "1f1ea",
            "1f1ea-1f1f8",
            "1f1eb",
            "1f1eb-1f1f7",
            "1f1ec",
            "1f1ec-1f1e7",
            "1f1ed",
            "1f1ee",
            "1f1ee-1f1f9",
            "1f1ef",
            "1f1ef-1f1f5",
            "1f1f0",
            "1f1f0-1f1f7",
            "1f1f1",
            "1f1f2",
            "1f1f3",
            "1f1f4",
            "1f1f5",
            "1f1f6",
            "1f1f7",
            "1f1f7-1f1fa",
            "1f1f8",
            "1f1f9",
            "1f1fa",
            "1f1fa-1f1f8",
            "1f1fb",
            "1f1fc",
            "1f1fd",
            "1f1fe",
            "1f1ff",
            "1f201",
            "1f202",
            "1f21a",
            "1f22f",
            "1f232",
            "1f233",
            "1f234",
            "1f235",
            "1f236",
            "1f237",
            "1f238",
            "1f239",
            "1f23a",
            "1f250",
            "1f251",
            "1f300",
            "1f301",
            "1f302",
            "1f303",
            "1f304",
            "1f305",
            "1f306",
            "1f307",
            "1f308",
            "1f309",
            "1f30a",
            "1f30b",
            "1f30c",
            "1f30d",
            "1f30e",
            "1f30f",
            "1f310",
            "1f311",
            "1f312",
            "1f313",
            "1f314",
            "1f315",
            "1f316",
            "1f317",
            "1f318",
            "1f319",
            "1f31a",
            "1f31b",
            "1f31c",
            "1f31d",
            "1f31e",
            "1f31f",
            "1f320",
            "1f330",
            "1f331",
            "1f332",
            "1f333",
            "1f334",
            "1f335",
            "1f337",
            "1f338",
            "1f339",
            "1f33a",
            "1f33b",
            "1f33c",
            "1f33d",
            "1f33e",
            "1f33f",
            "1f340",
            "1f341",
            "1f342",
            "1f343",
            "1f344",
            "1f345",
            "1f346",
            "1f347",
            "1f348",
            "1f349",
            "1f34a",
            "1f34b",
            "1f34c",
            "1f34d",
            "1f34e",
            "1f34f",
            "1f350",
            "1f351",
            "1f352",
            "1f353",
            "1f354",
            "1f355",
            "1f356",
            "1f357",
            "1f358",
            "1f359",
            "1f35a",
            "1f35b",
            "1f35c",
            "1f35d",
            "1f35e",
            "1f35f",
            "1f360",
            "1f361",
            "1f362",
            "1f363",
            "1f364",
            "1f365",
            "1f366",
            "1f367",
            "1f368",
            "1f369",
            "1f36a",
            "1f36b",
            "1f36c",
            "1f36d",
            "1f36e",
            "1f36f",
            "1f370",
            "1f371",
            "1f372",
            "1f373",
            "1f374",
            "1f375",
            "1f376",
            "1f377",
            "1f378",
            "1f379",
            "1f37a",
            "1f37b",
            "1f37c",
            "1f380",
            "1f381",
            "1f382",
            "1f383",
            "1f384",
            "1f385",
            "1f386",
            "1f387",
            "1f388",
            "1f389",
            "1f38a",
            "1f38b",
            "1f38c",
            "1f38d",
            "1f38e",
            "1f38f",
            "1f390",
            "1f391",
            "1f392",
            "1f393",
            "1f3a0",
            "1f3a1",
            "1f3a2",
            "1f3a3",
            "1f3a4",
            "1f3a5",
            "1f3a6",
            "1f3a7",
            "1f3a8",
            "1f3a9",
            "1f3aa",
            "1f3ab",
            "1f3ac",
            "1f3ad",
            "1f3ae",
            "1f3af",
            "1f3b0",
            "1f3b1",
            "1f3b2",
            "1f3b3",
            "1f3b4",
            "1f3b5",
            "1f3b6",
            "1f3b7",
            "1f3b8",
            "1f3b9",
            "1f3ba",
            "1f3bb",
            "1f3bc",
            "1f3bd",
            "1f3be",
            "1f3bf",
            "1f3c0",
            "1f3c1",
            "1f3c2",
            "1f3c3",
            "1f3c4",
            "1f3c6",
            "1f3c7",
            "1f3c8",
            "1f3c9",
            "1f3ca",
            "1f3e0",
            "1f3e1",
            "1f3e2",
            "1f3e3",
            "1f3e4",
            "1f3e5",
            "1f3e6",
            "1f3e7",
            "1f3e8",
            "1f3e9",
            "1f3ea",
            "1f3eb",
            "1f3ec",
            "1f3ed",
            "1f3ee",
            "1f3ef",
            "1f3f0",
            "1f400",
            "1f401",
            "1f402",
            "1f403",
            "1f404",
            "1f405",
            "1f406",
            "1f407",
            "1f408",
            "1f409",
            "1f40a",
            "1f40b",
            "1f40c",
            "1f40d",
            "1f40e",
            "1f40f",
            "1f410",
            "1f411",
            "1f412",
            "1f413",
            "1f414",
            "1f415",
            "1f416",
            "1f417",
            "1f418",
            "1f419",
            "1f41a",
            "1f41b",
            "1f41c",
            "1f41d",
            "1f41e",
            "1f41f",
            "1f420",
            "1f421",
            "1f422",
            "1f423",
            "1f424",
            "1f425",
            "1f426",
            "1f427",
            "1f428",
            "1f429",
            "1f42a",
            "1f42b",
            "1f42c",
            "1f42d",
            "1f42e",
            "1f42f",
            "1f430",
            "1f431",
            "1f432",
            "1f433",
            "1f434",
            "1f435",
            "1f436",
            "1f437",
            "1f438",
            "1f439",
            "1f43a",
            "1f43b",
            "1f43c",
            "1f43d",
            "1f43e",
            "1f440",
            "1f442",
            "1f443",
            "1f444",
            "1f445",
            "1f446",
            "1f447",
            "1f448",
            "1f449",
            "1f44a",
            "1f44b",
            "1f44c",
            "1f44d",
            "1f44e",
            "1f44f",
            "1f450",
            "1f451",
            "1f452",
            "1f453",
            "1f454",
            "1f455",
            "1f456",
            "1f457",
            "1f458",
            "1f459",
            "1f45a",
            "1f45b",
            "1f45c",
            "1f45d",
            "1f45e",
            "1f45f",
            "1f460",
            "1f461",
            "1f462",
            "1f463",
            "1f464",
            "1f465",
            "1f466",
            "1f467",
            "1f468",
            "1f469",
            "1f46a",
            "1f46b",
            "1f46c",
            "1f46d",
            "1f46e",
            "1f46f",
            "1f470",
            "1f471",
            "1f472",
            "1f473",
            "1f474",
            "1f475",
            "1f476",
            "1f477",
            "1f478",
            "1f479",
            "1f47a",
            "1f47b",
            "1f47c",
            "1f47d",
            "1f47e",
            "1f47f",
            "1f480",
            "1f481",
            "1f482",
            "1f483",
            "1f484",
            "1f485",
            "1f486",
            "1f487",
            "1f488",
            "1f489",
            "1f48a",
            "1f48b",
            "1f48c",
            "1f48d",
            "1f48e",
            "1f48f",
            "1f490",
            "1f491",
            "1f492",
            "1f493",
            "1f494",
            "1f495",
            "1f496",
            "1f497",
            "1f498",
            "1f499",
            "1f49a",
            "1f49b",
            "1f49c",
            "1f49d",
            "1f49e",
            "1f49f",
            "1f4a0",
            "1f4a1",
            "1f4a2",
            "1f4a3",
            "1f4a4",
            "1f4a5",
            "1f4a6",
            "1f4a7",
            "1f4a8",
            "1f4a9",
            "1f4aa",
            "1f4ab",
            "1f4ac",
            "1f4ad",
            "1f4ae",
            "1f4af",
            "1f4b0",
            "1f4b1",
            "1f4b2",
            "1f4b3",
            "1f4b4",
            "1f4b5",
            "1f4b6",
            "1f4b7",
            "1f4b8",
            "1f4b9",
            "1f4ba",
            "1f4bb",
            "1f4bc",
            "1f4bd",
            "1f4be",
            "1f4bf",
            "1f4c0",
            "1f4c1",
            "1f4c2",
            "1f4c3",
            "1f4c4",
            "1f4c5",
            "1f4c6",
            "1f4c7",
            "1f4c8",
            "1f4c9",
            "1f4ca",
            "1f4cb",
            "1f4cc",
            "1f4cd",
            "1f4ce",
            "1f4cf",
            "1f4d0",
            "1f4d1",
            "1f4d2",
            "1f4d3",
            "1f4d4",
            "1f4d5",
            "1f4d6",
            "1f4d7",
            "1f4d8",
            "1f4d9",
            "1f4da",
            "1f4db",
            "1f4dc",
            "1f4dd",
            "1f4de",
            "1f4df",
            "1f4e0",
            "1f4e1",
            "1f4e2",
            "1f4e3",
            "1f4e4",
            "1f4e5",
            "1f4e6",
            "1f4e7",
            "1f4e8",
            "1f4e9",
            "1f4ea",
            "1f4eb",
            "1f4ec",
            "1f4ed",
            "1f4ee",
            "1f4ef",
            "1f4f0",
            "1f4f1",
            "1f4f2",
            "1f4f3",
            "1f4f4",
            "1f4f5",
            "1f4f6",
            "1f4f7",
            "1f4f9",
            "1f4fa",
            "1f4fb",
            "1f4fc",
            "1f500",
            "1f501",
            "1f502",
            "1f503",
            "1f504",
            "1f505",
            "1f506",
            "1f507",
            "1f508",
            "1f509",
            "1f50a",
            "1f50b",
            "1f50c",
            "1f50d",
            "1f50e",
            "1f50f",
            "1f510",
            "1f511",
            "1f512",
            "1f513",
            "1f514",
            "1f515",
            "1f516",
            "1f517",
            "1f518",
            "1f519",
            "1f51a",
            "1f51b",
            "1f51c",
            "1f51d",
            "1f51e",
            "1f51f",
            "1f520",
            "1f521",
            "1f522",
            "1f523",
            "1f524",
            "1f525",
            "1f526",
            "1f527",
            "1f528",
            "1f529",
            "1f52a",
            "1f52b",
            "1f52c",
            "1f52d",
            "1f52e",
            "1f52f",
            "1f530",
            "1f531",
            "1f532",
            "1f533",
            "1f534",
            "1f535",
            "1f536",
            "1f537",
            "1f538",
            "1f539",
            "1f53a",
            "1f53b",
            "1f53c",
            "1f53d",
            "1f550",
            "1f551",
            "1f552",
            "1f553",
            "1f554",
            "1f555",
            "1f556",
            "1f557",
            "1f558",
            "1f559",
            "1f55a",
            "1f55b",
            "1f55c",
            "1f55d",
            "1f55e",
            "1f55f",
            "1f560",
            "1f561",
            "1f562",
            "1f563",
            "1f564",
            "1f565",
            "1f566",
            "1f567",
            "1f5fb",
            "1f5fc",
            "1f5fd",
            "1f5fe",
            "1f5ff",
            "1f600",
            "1f601",
            "1f602",
            "1f603",
            "1f604",
            "1f605",
            "1f606",
            "1f607",
            "1f608",
            "1f609",
            "1f60a",
            "1f60b",
            "1f60c",
            "1f60d",
            "1f60e",
            "1f60f",
            "1f610",
            "1f611",
            "1f612",
            "1f613",
            "1f614",
            "1f615",
            "1f616",
            "1f617",
            "1f618",
            "1f619",
            "1f61a",
            "1f61b",
            "1f61c",
            "1f61d",
            "1f61e",
            "1f61f",
            "1f620",
            "1f621",
            "1f622",
            "1f623",
            "1f624",
            "1f625",
            "1f626",
            "1f627",
            "1f628",
            "1f629",
            "1f62a",
            "1f62b",
            "1f62c",
            "1f62d",
            "1f62e",
            "1f62f",
            "1f630",
            "1f631",
            "1f632",
            "1f633",
            "1f634",
            "1f635",
            "1f636",
            "1f637",
            "1f638",
            "1f639",
            "1f63a",
            "1f63b",
            "1f63c",
            "1f63d",
            "1f63e",
            "1f63f",
            "1f640",
            "1f645",
            "1f646",
            "1f647",
            "1f648",
            "1f649",
            "1f64a",
            "1f64b",
            "1f64c",
            "1f64d",
            "1f64e",
            "1f64f",
            "1f680",
            "1f681",
            "1f682",
            "1f683",
            "1f684",
            "1f685",
            "1f686",
            "1f687",
            "1f688",
            "1f689",
            "1f68a",
            "1f68b",
            "1f68c",
            "1f68d",
            "1f68e",
            "1f68f",
            "1f690",
            "1f691",
            "1f692",
            "1f693",
            "1f694",
            "1f695",
            "1f696",
            "1f697",
            "1f698",
            "1f699",
            "1f69a",
            "1f69b",
            "1f69c",
            "1f69d",
            "1f69e",
            "1f69f",
            "1f6a0",
            "1f6a1",
            "1f6a2",
            "1f6a3",
            "1f6a4",
            "1f6a5",
            "1f6a6",
            "1f6a7",
            "1f6a8",
            "1f6a9",
            "1f6aa",
            "1f6ab",
            "1f6ac",
            "1f6ad",
            "1f6ae",
            "1f6af",
            "1f6b0",
            "1f6b1",
            "1f6b2",
            "1f6b3",
            "1f6b4",
            "1f6b5",
            "1f6b6",
            "1f6b7",
            "1f6b8",
            "1f6b9",
            "1f6ba",
            "1f6bb",
            "1f6bc",
            "1f6bd",
            "1f6be",
            "1f6bf",
            "1f6c0",
            "1f6c1",
            "1f6c2",
            "1f6c3",
            "1f6c4",
            "1f6c5",
            "203c",
            "2049",
            "2122",
            "2139",
            "2194",
            "2195",
            "2196",
            "2197",
            "2198",
            "2199",
            "21a9",
            "21aa",
            "23-20e3",
            "231a",
            "231b",
            "23e9",
            "23ea",
            "23eb",
            "23ec",
            "23f0",
            "23f3",
            "24c2",
            "25aa",
            "25ab",
            "25b6",
            "25c0",
            "25fb",
            "25fc",
            "25fd",
            "25fe",
            "2600",
            "2601",
            "260e",
            "2611",
            "2614",
            "2615",
            "261d",
            "263a",
            "2648",
            "2649",
            "264a",
            "264b",
            "264c",
            "264d",
            "264e",
            "264f",
            "2650",
            "2651",
            "2652",
            "2653",
            "2660",
            "2663",
            "2665",
            "2666",
            "2668",
            "267b",
            "267f",
            "2693",
            "26a0",
            "26a1",
            "26aa",
            "26ab",
            "26bd",
            "26be",
            "26c4",
            "26c5",
            "26ce",
            "26d4",
            "26ea",
            "26f2",
            "26f3",
            "26f5",
            "26fa",
            "26fd",
            "2702",
            "2705",
            "2708",
            "2709",
            "270a",
            "270b",
            "270c",
            "270f",
            "2712",
            "2714",
            "2716",
            "2728",
            "2733",
            "2734",
            "2744",
            "2747",
            "274c",
            "274e",
            "2753",
            "2754",
            "2755",
            "2757",
            "2764",
            "2795",
            "2796",
            "2797",
            "27a1",
            "27b0",
            "27bf",
            "2934",
            "2935",
            "2b05",
            "2b06",
            "2b07",
            "2b1b",
            "2b1c",
            "2b50",
            "2b55",
            "30-20e3",
            "3030",
            "303d",
            "31-20e3",
            "32-20e3",
            "3297",
            "3299",
            "33-20e3",
            "34-20e3",
            "35-20e3",
            "36-20e3",
            "37-20e3",
            "38-20e3",
            "39-20e3",
            "a9",
            "ae",
            "e50a",
        };

        public static string ReplaceEmojiToImg(string text)
        {
            // HTMLタグを壊さないように <...> の外側のみを置換する
            return Regex.Replace(text, @"^[^<]+$|^[^<]+(?:<)|(?:>)[^<]+(?:<)|(?:>)[^<]+$", m =>
            {
                return Regex.Replace(m.Value,
                    "(?:\\ud83c\\udde8\\ud83c\\uddf3|\\ud83c\\uddfa\\ud83c\\uddf8|\\ud83c\\uddf7\\ud83c\\uddfa|\\ud83c\\uddf0\\ud83c\\uddf7|\\ud83c\\uddef\\ud83c\\uddf5|\\ud83c\\uddee\\ud83c\\uddf9|\\ud83c\\uddec\\ud83c\\udde7|\\ud83c\\uddeb\\ud83c\\uddf7|\\ud83c\\uddea\\ud83c\\uddf8|\\ud83c\\udde9\\ud83c\\uddea|\\u0039\\ufe0f?\\u20e3|\\u0038\\ufe0f?\\u20e3|\\u0037\\ufe0f?\\u20e3|\\u0036\\ufe0f?\\u20e3|\\u0035\\ufe0f?\\u20e3|\\u0034\\ufe0f?\\u20e3|\\u0033\\ufe0f?\\u20e3|\\u0032\\ufe0f?\\u20e3|\\u0031\\ufe0f?\\u20e3|\\u0030\\ufe0f?\\u20e3|\\u0023\\ufe0f?\\u20e3|\\ud83d\\udeb3|\\ud83d\\udeb1|\\ud83d\\udeb0|\\ud83d\\udeaf|\\ud83d\\udeae|\\ud83d\\udea6|\\ud83d\\udea3|\\ud83d\\udea1|\\ud83d\\udea0|\\ud83d\\ude9f|\\ud83d\\ude9e|\\ud83d\\ude9d|\\ud83d\\ude9c|\\ud83d\\ude9b|\\ud83d\\ude98|\\ud83d\\ude96|\\ud83d\\ude94|\\ud83d\\ude90|\\ud83d\\ude8e|\\ud83d\\ude8d|\\ud83d\\ude8b|\\ud83d\\ude8a|\\ud83d\\ude88|\\ud83d\\ude86|\\ud83d\\ude82|\\ud83d\\ude81|\\ud83d\\ude36|\\ud83d\\ude34|\\ud83d\\ude2f|\\ud83d\\ude2e|\\ud83d\\ude2c|\\ud83d\\ude27|\\ud83d\\ude26|\\ud83d\\ude1f|\\ud83d\\ude1b|\\ud83d\\ude19|\\ud83d\\ude17|\\ud83d\\ude15|\\ud83d\\ude11|\\ud83d\\ude10|\\ud83d\\ude0e|\\ud83d\\ude08|\\ud83d\\ude07|\\ud83d\\ude00|\\ud83d\\udd67|\\ud83d\\udd66|\\ud83d\\udd65|\\ud83d\\udd64|\\ud83d\\udd63|\\ud83d\\udd62|\\ud83d\\udd61|\\ud83d\\udd60|\\ud83d\\udd5f|\\ud83d\\udd5e|\\ud83d\\udd5d|\\ud83d\\udd5c|\\ud83d\\udd2d|\\ud83d\\udd2c|\\ud83d\\udd15|\\ud83d\\udd09|\\ud83d\\udd08|\\ud83d\\udd07|\\ud83d\\udd06|\\ud83d\\udd05|\\ud83d\\udd04|\\ud83d\\udd02|\\ud83d\\udd01|\\ud83d\\udd00|\\ud83d\\udcf5|\\ud83d\\udcef|\\ud83d\\udced|\\ud83d\\udcec|\\ud83d\\udcb7|\\ud83d\\udcb6|\\ud83d\\udcad|\\ud83d\\udc6d|\\ud83d\\udc6c|\\ud83d\\udc65|\\ud83d\\udc2a|\\ud83d\\udc16|\\ud83d\\udc15|\\ud83d\\udc13|\\ud83d\\udc10|\\ud83d\\udc0f|\\ud83d\\udc0b|\\ud83d\\udc0a|\\ud83d\\udc09|\\ud83d\\udc08|\\ud83d\\udc07|\\ud83d\\udc06|\\ud83d\\udc05|\\ud83d\\udc04|\\ud83d\\udc03|\\ud83d\\udc02|\\ud83d\\udc01|\\ud83d\\udc00|\\ud83c\\udfe4|\\ud83c\\udfc9|\\ud83c\\udfc7|\\ud83c\\udf7c|\\ud83c\\udf50|\\ud83c\\udf4b|\\ud83c\\udf33|\\ud83c\\udf32|\\ud83c\\udf1e|\\ud83c\\udf1d|\\ud83c\\udf1c|\\ud83c\\udf1a|\\ud83c\\udf18|\\ud83c\\udccf|\\ud83c\\udd70|\\ud83c\\udd71|\\ud83c\\udd7e|\\ud83c\\udd8e|\\ud83c\\udd91|\\ud83c\\udd92|\\ud83c\\udd93|\\ud83c\\udd94|\\ud83c\\udd95|\\ud83c\\udd96|\\ud83c\\udd97|\\ud83c\\udd98|\\ud83c\\udd99|\\ud83c\\udd9a|\\ud83d\\udc77|\\ud83d\\udec5|\\ud83d\\udec4|\\ud83d\\udec3|\\ud83d\\udec2|\\ud83d\\udec1|\\ud83d\\udebf|\\ud83d\\udeb8|\\ud83d\\udeb7|\\ud83d\\udeb5|\\ud83c\\ude01|\\ud83c\\ude02|\\ud83c\\ude32|\\ud83c\\ude33|\\ud83c\\ude34|\\ud83c\\ude35|\\ud83c\\ude36|\\ud83c\\ude37|\\ud83c\\ude38|\\ud83c\\ude39|\\ud83c\\ude3a|\\ud83c\\ude50|\\ud83c\\ude51|\\ud83c\\udf00|\\ud83c\\udf01|\\ud83c\\udf02|\\ud83c\\udf03|\\ud83c\\udf04|\\ud83c\\udf05|\\ud83c\\udf06|\\ud83c\\udf07|\\ud83c\\udf08|\\ud83c\\udf09|\\ud83c\\udf0a|\\ud83c\\udf0b|\\ud83c\\udf0c|\\ud83c\\udf0f|\\ud83c\\udf11|\\ud83c\\udf13|\\ud83c\\udf14|\\ud83c\\udf15|\\ud83c\\udf19|\\ud83c\\udf1b|\\ud83c\\udf1f|\\ud83c\\udf20|\\ud83c\\udf30|\\ud83c\\udf31|\\ud83c\\udf34|\\ud83c\\udf35|\\ud83c\\udf37|\\ud83c\\udf38|\\ud83c\\udf39|\\ud83c\\udf3a|\\ud83c\\udf3b|\\ud83c\\udf3c|\\ud83c\\udf3d|\\ud83c\\udf3e|\\ud83c\\udf3f|\\ud83c\\udf40|\\ud83c\\udf41|\\ud83c\\udf42|\\ud83c\\udf43|\\ud83c\\udf44|\\ud83c\\udf45|\\ud83c\\udf46|\\ud83c\\udf47|\\ud83c\\udf48|\\ud83c\\udf49|\\ud83c\\udf4a|\\ud83c\\udf4c|\\ud83c\\udf4d|\\ud83c\\udf4e|\\ud83c\\udf4f|\\ud83c\\udf51|\\ud83c\\udf52|\\ud83c\\udf53|\\ud83c\\udf54|\\ud83c\\udf55|\\ud83c\\udf56|\\ud83c\\udf57|\\ud83c\\udf58|\\ud83c\\udf59|\\ud83c\\udf5a|\\ud83c\\udf5b|\\ud83c\\udf5c|\\ud83c\\udf5d|\\ud83c\\udf5e|\\ud83c\\udf5f|\\ud83c\\udf60|\\ud83c\\udf61|\\ud83c\\udf62|\\ud83c\\udf63|\\ud83c\\udf64|\\ud83c\\udf65|\\ud83c\\udf66|\\ud83c\\udf67|\\ud83c\\udf68|\\ud83c\\udf69|\\ud83c\\udf6a|\\ud83c\\udf6b|\\ud83c\\udf6c|\\ud83c\\udf6d|\\ud83c\\udf6e|\\ud83c\\udf6f|\\ud83c\\udf70|\\ud83c\\udf71|\\ud83c\\udf72|\\ud83c\\udf73|\\ud83c\\udf74|\\ud83c\\udf75|\\ud83c\\udf76|\\ud83c\\udf77|\\ud83c\\udf78|\\ud83c\\udf79|\\ud83c\\udf7a|\\ud83c\\udf7b|\\ud83c\\udf80|\\ud83c\\udf81|\\ud83c\\udf82|\\ud83c\\udf83|\\ud83c\\udf84|\\ud83c\\udf85|\\ud83c\\udf86|\\ud83c\\udf87|\\ud83c\\udf88|\\ud83c\\udf89|\\ud83c\\udf8a|\\ud83c\\udf8b|\\ud83c\\udf8c|\\ud83c\\udf8d|\\ud83c\\udf8e|\\ud83c\\udf8f|\\ud83c\\udf90|\\ud83c\\udf91|\\ud83c\\udf92|\\ud83c\\udf93|\\ud83c\\udfa0|\\ud83c\\udfa1|\\ud83c\\udfa2|\\ud83c\\udfa3|\\ud83c\\udfa4|\\ud83c\\udfa5|\\ud83c\\udfa6|\\ud83c\\udfa7|\\ud83c\\udfa8|\\ud83c\\udfa9|\\ud83c\\udfaa|\\ud83c\\udfab|\\ud83c\\udfac|\\ud83c\\udfad|\\ud83c\\udfae|\\ud83c\\udfaf|\\ud83c\\udfb0|\\ud83c\\udfb1|\\ud83c\\udfb2|\\ud83c\\udfb3|\\ud83c\\udfb4|\\ud83c\\udfb5|\\ud83c\\udfb6|\\ud83c\\udfb7|\\ud83c\\udfb8|\\ud83c\\udfb9|\\ud83c\\udfba|\\ud83c\\udfbb|\\ud83c\\udfbc|\\ud83c\\udfbd|\\ud83c\\udfbe|\\ud83c\\udfbf|\\ud83c\\udfc0|\\ud83c\\udfc1|\\ud83c\\udfc2|\\ud83c\\udfc3|\\ud83c\\udfc4|\\ud83c\\udfc6|\\ud83c\\udfc8|\\ud83c\\udfca|\\ud83c\\udfe0|\\ud83c\\udfe1|\\ud83c\\udfe2|\\ud83c\\udfe3|\\ud83c\\udfe5|\\ud83c\\udfe6|\\ud83c\\udfe7|\\ud83c\\udfe8|\\ud83c\\udfe9|\\ud83c\\udfea|\\ud83c\\udfeb|\\ud83c\\udfec|\\ud83c\\udfed|\\ud83c\\udfee|\\ud83c\\udfef|\\ud83c\\udff0|\\ud83d\\udc0c|\\ud83d\\udc0d|\\ud83d\\udc0e|\\ud83d\\udc11|\\ud83d\\udc12|\\ud83d\\udc14|\\ud83d\\udc17|\\ud83d\\udc18|\\ud83d\\udc19|\\ud83d\\udc1a|\\ud83d\\udc1b|\\ud83d\\udc1c|\\ud83d\\udc1d|\\ud83d\\udc1e|\\ud83d\\udc1f|\\ud83d\\udc20|\\ud83d\\udc21|\\ud83d\\udc22|\\ud83d\\udc23|\\ud83d\\udc24|\\ud83d\\udc25|\\ud83d\\udc26|\\ud83d\\udc27|\\ud83d\\udc28|\\ud83d\\udc29|\\ud83d\\udc2b|\\ud83d\\udc2c|\\ud83d\\udc2d|\\ud83d\\udc2e|\\ud83d\\udc2f|\\ud83d\\udc30|\\ud83d\\udc31|\\ud83d\\udc32|\\ud83d\\udc33|\\ud83d\\udc34|\\ud83d\\udc35|\\ud83d\\udc36|\\ud83d\\udc37|\\ud83d\\udc38|\\ud83d\\udc39|\\ud83d\\udc3a|\\ud83d\\udc3b|\\ud83d\\udc3c|\\ud83d\\udc3d|\\ud83d\\udc3e|\\ud83d\\udc40|\\ud83d\\udc42|\\ud83d\\udc43|\\ud83d\\udc44|\\ud83d\\udc45|\\ud83d\\udc46|\\ud83d\\udc47|\\ud83d\\udc48|\\ud83d\\udc49|\\ud83d\\udc4a|\\ud83d\\udc4b|\\ud83d\\udc4c|\\ud83d\\udc4d|\\ud83d\\udc4e|\\ud83d\\udc4f|\\ud83d\\udc50|\\ud83d\\udc51|\\ud83d\\udc52|\\ud83d\\udc53|\\ud83d\\udc54|\\ud83d\\udc55|\\ud83d\\udc56|\\ud83d\\udc57|\\ud83d\\udc58|\\ud83d\\udc59|\\ud83d\\udc5a|\\ud83d\\udc5b|\\ud83d\\udc5c|\\ud83d\\udc5d|\\ud83d\\udc5e|\\ud83d\\udc5f|\\ud83d\\udc60|\\ud83d\\udc61|\\ud83d\\udc62|\\ud83d\\udc63|\\ud83d\\udc64|\\ud83d\\udc66|\\ud83d\\udc67|\\ud83d\\udc68|\\ud83d\\udc69|\\ud83d\\udc6a|\\ud83d\\udc6b|\\ud83d\\udc6e|\\ud83d\\udc6f|\\ud83d\\udc70|\\ud83d\\udc71|\\ud83d\\udc72|\\ud83d\\udc73|\\ud83d\\udc74|\\ud83d\\udc75|\\ud83d\\udc76|\\ud83d\\udeb4|\\ud83d\\udc78|\\ud83d\\udc79|\\ud83d\\udc7a|\\ud83d\\udc7b|\\ud83d\\udc7c|\\ud83d\\udc7d|\\ud83d\\udc7e|\\ud83d\\udc7f|\\ud83d\\udc80|\\ud83d\\udc81|\\ud83d\\udc82|\\ud83d\\udc83|\\ud83d\\udc84|\\ud83d\\udc85|\\ud83d\\udc86|\\ud83d\\udc87|\\ud83d\\udc88|\\ud83d\\udc89|\\ud83d\\udc8a|\\ud83d\\udc8b|\\ud83d\\udc8c|\\ud83d\\udc8d|\\ud83d\\udc8e|\\ud83d\\udc8f|\\ud83d\\udc90|\\ud83d\\udc91|\\ud83d\\udc92|\\ud83d\\udc93|\\ud83d\\udc94|\\ud83d\\udc95|\\ud83d\\udc96|\\ud83d\\udc97|\\ud83d\\udc98|\\ud83d\\udc99|\\ud83d\\udc9a|\\ud83d\\udc9b|\\ud83d\\udc9c|\\ud83d\\udc9d|\\ud83d\\udc9e|\\ud83d\\udc9f|\\ud83d\\udca0|\\ud83d\\udca1|\\ud83d\\udca2|\\ud83d\\udca3|\\ud83d\\udca4|\\ud83d\\udca5|\\ud83d\\udca6|\\ud83d\\udca7|\\ud83d\\udca8|\\ud83d\\udca9|\\ud83d\\udcaa|\\ud83d\\udcab|\\ud83d\\udcac|\\ud83d\\udcae|\\ud83d\\udcaf|\\ud83d\\udcb0|\\ud83d\\udcb1|\\ud83d\\udcb2|\\ud83d\\udcb3|\\ud83d\\udcb4|\\ud83d\\udcb5|\\ud83d\\udcb8|\\ud83d\\udcb9|\\ud83d\\udcba|\\ud83d\\udcbb|\\ud83d\\udcbc|\\ud83d\\udcbd|\\ud83d\\udcbe|\\ud83d\\udcbf|\\ud83d\\udcc0|\\ud83d\\udcc1|\\ud83d\\udcc2|\\ud83d\\udcc3|\\ud83d\\udcc4|\\ud83d\\udcc5|\\ud83d\\udcc6|\\ud83d\\udcc7|\\ud83d\\udcc8|\\ud83d\\udcc9|\\ud83d\\udcca|\\ud83d\\udccb|\\ud83d\\udccc|\\ud83d\\udccd|\\ud83d\\udcce|\\ud83d\\udccf|\\ud83d\\udcd0|\\ud83d\\udcd1|\\ud83d\\udcd2|\\ud83d\\udcd3|\\ud83d\\udcd4|\\ud83d\\udcd5|\\ud83d\\udcd6|\\ud83d\\udcd7|\\ud83d\\udcd8|\\ud83d\\udcd9|\\ud83d\\udcda|\\ud83d\\udcdb|\\ud83d\\udcdc|\\ud83d\\udcdd|\\ud83d\\udcde|\\ud83d\\udcdf|\\ud83d\\udce0|\\ud83d\\udce1|\\ud83d\\udce2|\\ud83d\\udce3|\\ud83d\\udce4|\\ud83d\\udce5|\\ud83d\\udce6|\\ud83d\\udce7|\\ud83d\\udce8|\\ud83d\\udce9|\\ud83d\\udcea|\\ud83d\\udceb|\\ud83d\\udcee|\\ud83d\\udcf0|\\ud83d\\udcf1|\\ud83d\\udcf2|\\ud83d\\udcf3|\\ud83d\\udcf4|\\ud83d\\udcf6|\\ud83d\\udcf7|\\ud83d\\udcf9|\\ud83d\\udcfa|\\ud83d\\udcfb|\\ud83d\\udcfc|\\ud83d\\udd03|\\ud83d\\udd0a|\\ud83d\\udd0b|\\ud83d\\udd0c|\\ud83d\\udd0d|\\ud83d\\udd0e|\\ud83d\\udd0f|\\ud83d\\udd10|\\ud83d\\udd11|\\ud83d\\udd12|\\ud83d\\udd13|\\ud83d\\udd14|\\ud83d\\udd16|\\ud83d\\udd17|\\ud83d\\udd18|\\ud83d\\udd19|\\ud83d\\udd1a|\\ud83d\\udd1b|\\ud83d\\udd1c|\\ud83d\\udd1d|\\ud83d\\udd1e|\\ud83d\\udd1f|\\ud83d\\udd20|\\ud83d\\udd21|\\ud83d\\udd22|\\ud83d\\udd23|\\ud83d\\udd24|\\ud83d\\udd25|\\ud83d\\udd26|\\ud83d\\udd27|\\ud83d\\udd28|\\ud83d\\udd29|\\ud83d\\udd2a|\\ud83d\\udd2b|\\ud83d\\udd2e|\\ud83d\\udd2f|\\ud83d\\udd30|\\ud83d\\udd31|\\ud83d\\udd32|\\ud83d\\udd33|\\ud83d\\udd34|\\ud83d\\udd35|\\ud83d\\udd36|\\ud83d\\udd37|\\ud83d\\udd38|\\ud83d\\udd39|\\ud83d\\udd3a|\\ud83d\\udd3b|\\ud83d\\udd3c|\\ud83d\\udd3d|\\ud83d\\udd50|\\ud83d\\udd51|\\ud83d\\udd52|\\ud83d\\udd53|\\ud83d\\udd54|\\ud83d\\udd55|\\ud83d\\udd56|\\ud83d\\udd57|\\ud83d\\udd58|\\ud83d\\udd59|\\ud83d\\udd5a|\\ud83d\\udd5b|\\ud83d\\uddfb|\\ud83d\\uddfc|\\ud83d\\uddfd|\\ud83d\\uddfe|\\ud83d\\uddff|\\ud83d\\ude01|\\ud83d\\ude02|\\ud83d\\ude03|\\ud83d\\ude04|\\ud83d\\ude05|\\ud83d\\ude06|\\ud83d\\ude09|\\ud83d\\ude0a|\\ud83d\\ude0b|\\ud83d\\ude0c|\\ud83d\\ude0d|\\ud83d\\ude0f|\\ud83d\\ude12|\\ud83d\\ude13|\\ud83d\\ude14|\\ud83d\\ude16|\\ud83d\\ude18|\\ud83d\\ude1a|\\ud83d\\ude1c|\\ud83d\\ude1d|\\ud83d\\ude1e|\\ud83d\\ude20|\\ud83d\\ude21|\\ud83d\\ude22|\\ud83d\\ude23|\\ud83d\\ude24|\\ud83d\\ude25|\\ud83d\\ude28|\\ud83d\\ude29|\\ud83d\\ude2a|\\ud83d\\ude2b|\\ud83d\\ude2d|\\ud83d\\ude30|\\ud83d\\ude31|\\ud83d\\ude32|\\ud83d\\ude33|\\ud83d\\ude35|\\ud83d\\ude37|\\ud83d\\ude38|\\ud83d\\ude39|\\ud83d\\ude3a|\\ud83d\\ude3b|\\ud83d\\ude3c|\\ud83d\\ude3d|\\ud83d\\ude3e|\\ud83d\\ude3f|\\ud83d\\ude40|\\ud83d\\ude45|\\ud83d\\ude46|\\ud83d\\ude47|\\ud83d\\ude48|\\ud83d\\ude49|\\ud83d\\ude4a|\\ud83d\\ude4b|\\ud83d\\ude4c|\\ud83d\\ude4d|\\ud83d\\ude4e|\\ud83d\\ude4f|\\ud83d\\ude80|\\ud83d\\ude83|\\ud83d\\ude84|\\ud83d\\ude85|\\ud83d\\ude87|\\ud83d\\ude89|\\ud83d\\ude8c|\\ud83d\\ude8f|\\ud83d\\ude91|\\ud83d\\ude92|\\ud83d\\ude93|\\ud83d\\ude95|\\ud83d\\ude97|\\ud83d\\ude99|\\ud83d\\ude9a|\\ud83d\\udea2|\\ud83d\\udea4|\\ud83d\\udea5|\\ud83d\\udea7|\\ud83d\\udea8|\\ud83d\\udea9|\\ud83d\\udeaa|\\ud83d\\udeab|\\ud83d\\udeac|\\ud83d\\udead|\\ud83d\\udeb2|\\ud83d\\udeb6|\\ud83d\\udeb9|\\ud83d\\udeba|\\ud83d\\udebb|\\ud83d\\udebc|\\ud83d\\udebd|\\ud83d\\udebe|\\ud83d\\udec0|\\ud83c\\udde6|\\ud83c\\udde7|\\ud83c\\udde8|\\ud83c\\udde9|\\ud83c\\uddea|\\ud83c\\uddeb|\\ud83c\\uddec|\\ud83c\\udded|\\ud83c\\uddee|\\ud83c\\uddef|\\ud83c\\uddf0|\\ud83c\\uddf1|\\ud83c\\uddf2|\\ud83c\\uddf3|\\ud83c\\uddf4|\\ud83c\\uddf5|\\ud83c\\uddf6|\\ud83c\\uddf7|\\ud83c\\uddf8|\\ud83c\\uddf9|\\ud83c\\uddfa|\\ud83c\\uddfb|\\ud83c\\uddfc|\\ud83c\\uddfd|\\ud83c\\uddfe|\\ud83c\\uddff|\\ud83c\\udf0d|\\ud83c\\udf0e|\\ud83c\\udf10|\\ud83c\\udf12|\\ud83c\\udf16|\\ud83c\\udf17|\\ue50a|\\u3030|\\u27b0|\\u2797|\\u2796|\\u2795|\\u2755|\\u2754|\\u2753|\\u274e|\\u274c|\\u2728|\\u270b|\\u270a|\\u2705|\\u26ce|\\u23f3|\\u23f0|\\u23ec|\\u23eb|\\u23ea|\\u23e9|\\u2122|\\u27bf|\\u00a9|\\u00ae)|(?:(?:\\ud83c\\udc04|\\ud83c\\udd7f|\\ud83c\\ude1a|\\ud83c\\ude2f|\\u3299|\\u303d|\\u2b55|\\u2b50|\\u2b1c|\\u2b1b|\\u2b07|\\u2b06|\\u2b05|\\u2935|\\u2934|\\u27a1|\\u2764|\\u2757|\\u2747|\\u2744|\\u2734|\\u2733|\\u2716|\\u2714|\\u2712|\\u270f|\\u270c|\\u2709|\\u2708|\\u2702|\\u26fd|\\u26fa|\\u26f5|\\u26f3|\\u26f2|\\u26ea|\\u26d4|\\u26c5|\\u26c4|\\u26be|\\u26bd|\\u26ab|\\u26aa|\\u26a1|\\u26a0|\\u2693|\\u267f|\\u267b|\\u3297|\\u2666|\\u2665|\\u2663|\\u2660|\\u2653|\\u2652|\\u2651|\\u2650|\\u264f|\\u264e|\\u264d|\\u264c|\\u264b|\\u264a|\\u2649|\\u2648|\\u263a|\\u261d|\\u2615|\\u2614|\\u2611|\\u260e|\\u2601|\\u2600|\\u25fe|\\u25fd|\\u25fc|\\u25fb|\\u25c0|\\u25b6|\\u25ab|\\u25aa|\\u24c2|\\u231b|\\u231a|\\u21aa|\\u21a9|\\u2199|\\u2198|\\u2197|\\u2196|\\u2195|\\u2194|\\u2139|\\u2049|\\u203c|\\u2668)([\\uFE0E\\uFE0F]?))",
                    ReplaceEmojiEntity);
            });
        }

        private static string ReplaceEmojiEntity(System.Text.RegularExpressions.Match m)
        {
            string input = m.Value;
            string codes = "";

            for (var i = 0; i < input.Length; i += char.IsSurrogatePair(input, i) ? 2 : 1)
            {
                var codepoint = char.ConvertToUtf32(input, i);

                if (i > 0)
                {
                    codes += "-";
                }

                codes += string.Format("{0:x}", codepoint);
            }

//            return "(len=" + m.Value.Length + ",codes=" + codes + ",value=" + m.Value + ")";

            if (emojiSet.Contains(codes)) {
                return "<img class=\"emoji\" src=\"https://twemoji.maxcdn.com/36x36/" + codes + ".png\" alt=\"" + m.Value + "\" />";
            }
            else
            {
                return m.Value;
            }

        }
    }
}
