/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.VolatileImage;

public abstract class DoubleBufferedCanvas
extends Canvas {
    private static final long serialVersionUID = -715400898691581874L;

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        VolatileImage image = this.createVolatileImage(width, height);
        do {
            if (image.validate(this.getGraphicsConfiguration()) == 2) {
                image = this.createVolatileImage(width, height);
            }
            if (image == null) {
                return;
            }
            Graphics2D g2 = image.createGraphics();
            this.setRenderingHints(g2);
            this.draw(g2);
            g2.dispose();
            g.drawImage(image, 0, 0, this);
        } while (image.contentsLost());
        image.flush();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public abstract void setRenderingHints(Graphics2D var1);

    public abstract void draw(Graphics2D var1);
}

