/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import jp.sf.orangesignal.ta.util.Assert;

public abstract class DateFormatUtils {
    public static Date parse(String source, String[] patterns) throws ParseException {
        return DateFormatUtils.parse(source, patterns, null, null);
    }

    public static Date parse(String source, String[] patterns, Locale locale) throws ParseException {
        return DateFormatUtils.parse(source, patterns, locale, null);
    }

    public static Date parse(String source, String[] patterns, Locale locale, TimeZone zone) throws ParseException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(patterns, "Patterns must not be null");
        Assert.noNullElements(patterns, "Patterns must not contain null elements");
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        for (String pattern : patterns) {
            if (parser == null) {
                parser = new SimpleDateFormat(pattern, locale != null ? locale : Locale.getDefault());
                if (zone != null) {
                    parser.setTimeZone(zone);
                }
            } else {
                parser.applyPattern(pattern);
            }
            pos.setIndex(0);
            Date date = parser.parse(source, pos);
            if (date == null) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + source, -1);
    }

    public static String format(Date date, String pattern) {
        return DateFormatUtils.format(date, pattern, null, null);
    }

    public static String format(Date date, String pattern, Locale locale) {
        return DateFormatUtils.format(date, pattern, locale, null);
    }

    public static String format(Date date, String pattern, Locale locale, TimeZone zone) {
        Assert.notNull(date, "Date must not be null");
        Assert.notNull(pattern, "Pattern must not be null");
        SimpleDateFormat formatter = locale != null ? new SimpleDateFormat(pattern, locale) : new SimpleDateFormat(pattern);
        if (zone != null) {
            formatter.setTimeZone(zone);
        }
        return formatter.format(date);
    }
}

