/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui;

import java.util.Calendar;
import java.util.Date;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.util.StringManager;

public enum PeriodType {
    THREE_MONTH{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 65;
                }
                case WEEKLY: {
                    return 13;
                }
                case MONTHLY: {
                    return 3;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("3month", new Object[0]);
        }
    }
    ,
    SIX_MONTH{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 127;
                }
                case WEEKLY: {
                    return 26;
                }
                case MONTHLY: {
                    return 6;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("6month", new Object[0]);
        }
    }
    ,
    ONE_YEAR{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 246;
                }
                case WEEKLY: {
                    return 52;
                }
                case MONTHLY: {
                    return 12;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("1year", new Object[0]);
        }
    }
    ,
    TWO_YEAR{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 492;
                }
                case WEEKLY: {
                    return 104;
                }
                case MONTHLY: {
                    return 24;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("2year", new Object[0]);
        }
    }
    ,
    THREE_YEAR{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 738;
                }
                case WEEKLY: {
                    return 156;
                }
                case MONTHLY: {
                    return 36;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("3year", new Object[0]);
        }
    }
    ,
    FOUR_YEAR{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 984;
                }
                case WEEKLY: {
                    return 208;
                }
                case MONTHLY: {
                    return 48;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("4year", new Object[0]);
        }
    }
    ,
    FIVE_YEAR{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 1230;
                }
                case WEEKLY: {
                    return 260;
                }
                case MONTHLY: {
                    return 60;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("5year", new Object[0]);
        }
    }
    ,
    TEN_YEAR{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: {
                    return 2460;
                }
                case WEEKLY: {
                    return 520;
                }
                case MONTHLY: {
                    return 120;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("10year", new Object[0]);
        }
    }
    ,
    ALL{

        @Override
        public int getPeriod(DatasetType unit) {
            switch (unit) {
                case DAILY: 
                case WEEKLY: 
                case MONTHLY: {
                    return -1;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return StringManager.getString("all", new Object[0]);
        }
    };


    public abstract int getPeriod(DatasetType var1);

    public Date getPreviousDate(Date date) {
        if (this == ALL || date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -this.getPeriod(DatasetType.MONTHLY));
        return c.getTime();
    }
}

