/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset;

/**
 * 時系列データの足単位変換方法の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum CompressType {

	/**
	 * 最初の値を使用します。
	 */
	FIRST,

	/**
	 * 最高値を使用します。
	 */
	HIGHEST,

	/**
	 * 最安値を使用します。
	 */
	LOWEST,

	/**
	 * 最後の値を使用します。
	 */
	LAST,

	/**
	 * 合計値を使用します。
	 */
	SUM

}
