package jp.sourceforge.orangesignal.ta.dataset.loader;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import org.junit.Test;

public class LoadExceptionTest {

	@Test
	public void デフォルトコンストラクタ() {
		LoadException e = new LoadException();
		assertNull(e.getMessage());
		assertNull(e.getCause());
	}

	@Test
	public void 詳細なエラーメッセージを指定するコンストラクタ() {
		LoadException e = new LoadException("xxx");
		assertEquals(e.getMessage(), "xxx");
		assertNull(e.getCause());
	}

	@Test
	public void 詳細なエラーメッセージと原因を指定するコンストラクタ() {
		LoadException e = new LoadException("xxx", new Throwable());
		assertEquals(e.getMessage(), "xxx");
		assertNotNull(e.getCause());
	}

	@Test
	public void 原因を指定するコンストラクタ() {
		LoadException e = new LoadException(new Throwable());
		assertNotNull(e.getMessage());
		assertNotNull(e.getCause());
	}

}
