/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.order;

import java.util.Date;

/**
 * 成行注文情報の基底クラスを提供します。
 * 
 * @author 杉澤 浩二
 */
abstract class AbstractMarketOrder extends AbstractOrder implements MarketOrder {

	private static final long serialVersionUID = 5479077766301812735L;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected AbstractMarketOrder() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 */
	protected AbstractMarketOrder(
			final String symbol,
			final String label,
			final Date date,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);
	}

	/**
	 * 実装は必ず {@link OrderType#MARKET} を返します。
	 */
	@Override public final OrderType getOrderType() { return OrderType.MARKET; }

}
