/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.ma;
import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.MovingAverage;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 価格と移動平均の交差をシグナルとするストラテジーの基底クラスを提供します。
 */
public abstract class MovingAverageCross extends TradingStrategySupport {

	/**
	 * 価格の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 価格の種類を返します。
	 * 
	 * @return 価格の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 価格の種類を設定します。
	 * 
	 * @param price 価格の種類
	 */
	public void setPrice(FourPrice price) { this.price = price; }

	/**
	 * 移動平均の期間を保持します。
	 */
	private int period = 9;

	/**
	 * 移動平均の期間を返します。
	 * 
	 * @return 移動平均の期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 移動平均の期間を設定します。
	 * 
	 * @param period 移動平均の期間
	 */
	public void setPeriod(int period) { this.period = period; }

	/**
	 * 移動平均の種類を保持します。
	 */
	private MovingAverage type = MovingAverage.SMA;

	/**
	 * 移動平均の種類を返します。
	 * 
	 * @return 移動平均の種類
	 */
	public MovingAverage getType() { return type; }

	/**
	 * 移動平均の種類を設定します。
	 * 
	 * @param type 移動平均の種類
	 */
	public void setType(MovingAverage type) { this.type = type; }

	// ----------------------------------------------------------------------

	/**
	 * 価格と移動平均の交差シグナルを保持します。
	 */
	protected CrossSignal[] cross;

	@Override
	public void prepare() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		final Number[] ma = ma(price, this.period, this.type);
		this.cross = cross(price, ma);
	}

	@Override
	public void close() {
		this.cross = null;
	}

}
