<#setting locale="ja_JP">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Language" content="ja" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="imagetoolbar" content="no" />
<title>Strategy Performance Report</title>
<link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body>
<div>

<div id="header">
<h1><a href="index.html">Strategy Performance Report</a></h1>
<h2>OrangeSignal.com Backtester</h2>
</div> 

<div class="right">
<h2>サマリー</h2>
<table>
<tbody>
<col align="left" /><col align="right" /><col align="right" /><col align="left" /><col align="right" /><col align="right" />
<tr><td>対象アイテム数</td><td>${summary.count}</td><td></td><td></td><td></td><td></td></tr>
<tr><td>有効アイテム数</td><td>${summary.validCount}</td><td>(${summary.percentValidCount?string("0.00%")})</td><td>トレード数</td><td>${summary.trades}</td><td></td></tr>
<tr><td colspan="6"><hr /></td></tr>
<tr><td>勝ちアイテム数</td><td>${win.count}</td><td>(${summary.percentWinCount?string("0.00%")})</td><td>勝ちトレード数</td><td>${summary.winTrades}</td><td>(${summary.percentWinTrades?string("0.00%")})</td></tr>
<tr><td>負けアイテム数</td><td>${loss.count}</td><td>(${summary.percentLossCount?string("0.00%")})</td><td>負けトレード数</td><td>${summary.lossTrades}</td><td>(${summary.percentLossTrades?string("0.00%")})</td></tr>
<tr><td colspan="6"><hr /></td></tr>
<tr>
<td>アイテム平均損益</td><td colspan="2"><#if summary.averageNetProfitByValidCount < 0><span class="loss"><#else><span></#if>${summary.averageNetProfitByValidCount?string("#,##0.00")}</span></td>
<td>トレード平均損益</td><td colspan="2"><#if summary.averageNetProfitByTrades < 0><span class="loss"><#else><span></#if>${summary.averageNetProfitByTrades?string("#,##0.00")}</span></td>
</tr>
</tbody>
</table>

<h2>アイテムリスト</h2>
<table>
<thead>
<tr><th>No.</th><th colspan="2">シンボル</th><th>損益</th><th title="プロフィットファクター">PF</th><th>勝率</th><th>トレード数</th><th colspan="2" title="最大ドローダウン">最大DD</th><th colspan="2"></th></tr>
</thead>
<tbody>
<col align="center" /><col align="center" /><col align="left" /><col align="right" /><col align="right" /><col align="right"/ ><col align="right" /><col align="right" /><col align="right" /><col align="center" /><col align="center" />
<#assign keys = stats?keys>
<#list keys as key>
<tr>
<td>${key_index + 1}</td>
<td>${key}</td><td>${stats[key].symbolName}</td>
<td><#if stats[key].netProfit < 0><span class="loss"><#else><span></#if>${stats[key].netProfit?string("#,##0")}</span></td>
<td><#if stats[key].profitFactor <= 1><span class="loss"><#else><span></#if>${stats[key].profitFactor?string("0.00")}</span></td>
<td>${stats[key].percentProfitable?string("0.00%")}</td>
<td>${stats[key].trades?string("#,##0")}</td>
<td><#if stats[key].maxDrawdown < 0><span class="loss"><#else><span></#if>${stats[key].maxDrawdown?string("#,##0")}</span></td>
<td><#if stats[key].percentMaxDrawdown < 0><span class="loss"><#else><span></#if>(${stats[key].percentMaxDrawdown?string("0.00%")})</span></td>
<td><a href="${key}_stats.html">パフォーマンス</a></td>
<td><a href="${key}_trades.html">トレードリスト</a></td>
</tr>
</#list>
</tbody>
</table>

<h2>設定</h2>
<table>
<tr><td>検証期間</td><td><#if backtester.startDate?exists>${backtester.startDate?string("yyyy/MM/dd")}</#if> - <#if backtester.endDate?exists>${backtester.endDate?string("yyyy/MM/dd")}</#if></td></tr>
<tr><td>ストラテジー</td><td><#list backtester.strategies as strategy>${strategy.strategyName}<br></#list></td></tr>
<tr><td>手数料モデル</td><td>${backtester.trader.commission}</td></tr>
<tr><td>スリッページ</td><td>${backtester.trader.slippage}</td></tr>
<tr><td>資金</td><td>${backtester.trader.initialCapital?string("#,##0")}</td></tr>
<tr><td>買い増し/売り増し限度回数</td><td>${backtester.trader.positionLimit}</td></tr>
<tr><td>デフォルトの注文数量</td><td>${backtester.trader.defaultQuantity}</td></tr>
<tr><td>トレードタイプ</td><td>${backtester.trader.tradeType}</td></tr>
<tr><td>デフォルトのトレードタイミング</td><td>${backtester.defaultOrderTiming}</td></tr>
</table>
</div>

<div style="clear: both;"> </div>
</div>

<div class="footer">
作成日時: ${timestamp?string("yyyy/MM/dd HH:mm:ss")}<br />
&copy; 2006-2009 <a href="http://www.orangesignal.com/">OrangeSignal.com</a>
</div>
</body>
</html>