package jp.sourceforge.orangesignal.trading.backtest.launcher;

import java.io.IOException;

import javax.annotation.Resource;

import jp.sourceforge.orangesignal.trading.backtest.BacktesterEvent;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.seasar.extension.unit.S2TestCase;

public class S2BacktesterLauncherTest extends S2TestCase {

	@Resource
	private S2BacktesterLauncher launcher;

	@Override
	protected void setUp() throws Exception {
		include("app.dicon");
	}

	public void testCreateOptions() {
		final Options options = BacktesterLauncher.createOptions();
		assertNotNull(options);
		assertNotNull(options.getOption(BacktesterLauncher.OPT_HELP));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_VERSION));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_FILE));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_TIME));
		assertNotNull(options.getOption(BacktesterLauncher.OPT_INFO));
	}

	public void testCreateGeneralOptionGroup() {
		final OptionGroup group = S2BacktesterLauncher.createGeneralOptionGroup();
		assertNotNull(group);
		assertNotNull(group.getOptions());
	}

	public void testMain() {
		S2BacktesterLauncher.main(new String[]{});
		assertTrue(true);
	}

	public void testLaunch() throws ParseException, IOException {
		final CommandLine commandline = new PosixParser().parse(S2BacktesterLauncher.options, new String[]{});
		launcher.launch(commandline);
		assertTrue(true);
	}

	public void testBacktestStart() {
		final BacktesterEvent event = new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null);
		launcher.backtestStart(event);
		assertTrue(true);
	}

	public void testBacktestProcessed() {
		final BacktesterEvent event = new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null);
		launcher.backtestProcessed(event);
		assertTrue(true);
	}

}
