package jp.sourceforge.orangesignal.ta.dataset.loader;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import javax.sql.DataSource;

import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset;
import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset.Interval;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DbDatasetLoaderTest {

	private static final String SYMBOL = "n225";
	private static final String SQL = "SELECT date, open, high, low, close, volume FROM price WHERE id = ? ORDER BY date";

	private DataSource dataSource;

	@Before
	public void setUp() throws Exception {
		final BeanFactory context = new ClassPathXmlApplicationContext("datasource-context.xml");
		this.dataSource = (DataSource) context.getBean("dataSource", DataSource.class);
	}

	@Test
	public void test_デフォルトコンストラクタ() {
		new DbDatasetLoader();
		assertTrue(true);
	}

	@Test
	public void test_セッター・ゲッター() {
		final DbDatasetLoader loader = new DbDatasetLoader();

		assertNull(loader.getDataSource());
		loader.setDataSource(this.dataSource);
		assertThat(loader.getDataSource(), is(this.dataSource));

		assertNull(loader.getSql());
		loader.setSql(SQL);
		assertThat(loader.getSql(), is(SQL));

		assertThat(loader.getInterval(), is(Interval.DAILY));
		loader.setInterval(Interval.MONTHLY);
		assertThat(loader.getInterval(), is(Interval.MONTHLY));
	}

	@Test(expected = LoadException.class)
	public void test_ロード失敗_データソース未指定() throws LoadException {
		final DbDatasetLoader loader = new DbDatasetLoader();
		loader.setSql(SQL);

		loader.setSymbol(SYMBOL);
		loader.load();
	}

	@Test(expected = LoadException.class)
	public void test_ロード失敗_SQL未指定() throws LoadException {
		assertNotNull(dataSource);

		final DbDatasetLoader loader = new DbDatasetLoader();
		loader.setDataSource(dataSource);

		loader.setSymbol(SYMBOL);
		loader.load();
	}

	@Test(expected = LoadException.class)
	public void test_ロード失敗_シンボル未指定() throws LoadException {
		assertNotNull(dataSource);

		final DbDatasetLoader loader = new DbDatasetLoader();
		loader.setDataSource(dataSource);
		loader.setSql(SQL);

		loader.load();
	}

	@Test
	public void test_ロード成功_シンボル不明() throws LoadException {
		assertNotNull(dataSource);

		final DbDatasetLoader loader = new DbDatasetLoader();
		loader.setDataSource(dataSource);
		loader.setSql(SQL);

		loader.setSymbol("god");
		final TimeSeriesDataset dataset = loader.load();
		assertNotNull(dataset);
		assertThat(dataset.getSymbol(), is("god"));
		assertThat(dataset.getLength(), is(0));
	}

	@Test
	public void test_ロード成功() throws LoadException {
		assertNotNull(dataSource);

		final DbDatasetLoader loader = new DbDatasetLoader();
		loader.setDataSource(dataSource);
		loader.setSql(SQL);
		assertTrue(true);

		loader.setSymbol("n225");
		final TimeSeriesDataset dataset = loader.load();
		assertNotNull(dataset);
		assertThat(dataset.getSymbol(), is(SYMBOL));
		assertTrue(dataset.getLength() > 0);
	}

}
