/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.filters;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.sma;
import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

/**
 * 指定された期間で平均化した出来高の範囲でフィルターするストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class VolumeAverageFilter extends StrategySupport {

	/**
	 * デフォルトコンストラクタです。
	 */
	public VolumeAverageFilter() {}

	/**
	 * 直近期間を保持します。
	 */
	private int period = 1;

	/**
	 * 直近期間を返します。
	 * 
	 * @return 直近期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 直近期間を設定します。
	 * 
	 * @param period 直近期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	/**
	 * 上限価格を保持します。
	 */
	private double upper;

	/**
	 * 上限価格を返します。
	 * 
	 * @return 上限価格
	 */
	public double getUpper() { return upper; }

	/**
	 * 上限価格を設定します。
	 * 
	 * @param upper 上限価格
	 */
	public void setUpper(final double upper) { this.upper = upper; }

	/**
	 * 下限価格を保持します。
	 */
	private double lower = 1000;

	/**
	 * 下限価格を返します。
	 * 
	 * @return 下限価格
	 */
	public double getLower() { return lower; }

	/**
	 * 下限価格を設定します。
	 * 
	 * @param lower 下限価格
	 */
	public void setLower(final double lower) { this.lower = lower; }

	/**
	 * 出来高平均データを保持します。
	 */
	private Number[] volume;

	@Override
	public void init() {
		final StandardDataset dataset = getDataset();
		volume = sma(dataset.getTechnicalVolume(), period);
	}

	@Override
	public StrategyStatus process() {
		final Number value = volume[getCurrentDataIndex()];
		return (value != null && ((upper > 0 && value.doubleValue() > upper) || (lower > 0 && value.doubleValue() < lower))) ? StrategyStatus.FILTER : StrategyStatus.NEXT;
	}

	@Override
	public void terminate() {
		volume = null;
	}

}
