/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.candle.CandlestickColor.WHITE;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

public class InsideBarLongEntry extends StrategySupport {

	protected Candlestick[] c;

	@Override
	public void init() {
		this.c = getDataset().getCandlestick();
	}

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (i <= 0 || c[i - 1] == null || c[i] == null)
			return NEXT;
		if (c[i - 1].contains(c[i]) && c[i].getColor() == WHITE)
			buy(getStrategyName());
		return NEXT;
	}

	@Override
	public void terminate() {
		this.c = null;
	}

}
