/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.mom;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

/**
 * モメンタムを使用するストラテジーの基底クラスを提供します。
 */
public abstract class Momentum extends StrategySupport {

	/**
	 * 4本値の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 4本値の種類を返します。
	 * 
	 * @return 4本値の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 4本値の種類を設定します。
	 * 
	 * @param price 4本値の種類
	 */
	public void setPrice(final FourPrice price) { this.price = price; }

	/**
	 * モメンタムの期間を保持します。
	 */
	private int period = 12;

	/**
	 * モメンタムの期間を返します。
	 * 
	 * @return モメンタムの期間
	 */
	public int getPeriod() { return period; }

	/**
	 * モメンタムの期間を設定します。
	 * 
	 * @param period モメンタムの期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	// ----------------------------------------------------------------------

	protected Number[] mom1;
	protected Number[] mom2;

	@Override
	public void init() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		this.mom1 = mom(price, period);
		this.mom2 = mom(this.mom1, 1);
	}

	@Override
	public void terminate() {
		this.mom1 = null;
		this.mom2 = null;
	}

}
