/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.ma;
import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.MovingAverage;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

/**
 * 短期移動平均と長期移動平均の交差をシグナルとするストラテジーの基底クラスを提供します。
 */
public abstract class MovingAverage2LineCross extends StrategySupport {

	/**
	 * 価格の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 価格の種類を返します。
	 * 
	 * @return 価格の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 価格の種類を設定します。
	 * 
	 * @param price 価格の種類
	 */
	public void setPrice(FourPrice price) { this.price = price; }

	/**
	 * 短期移動平均の期間を保持します。
	 */
	private int fast = 9;

	/**
	 * 短期移動平均の期間を返します。
	 * 
	 * @return 短期移動平均の期間
	 */
	public int getFast() { return fast; }

	/**
	 * 短期移動平均の期間を設定します。
	 * 
	 * @param fast 短期移動平均の期間
	 */
	public void setFast(int fast) { this.fast = fast; }

	/**
	 * 長期移動平均の期間を保持します。
	 */
	private int slow = 18;

	/**
	 * 長期移動平均の期間を返します。
	 * 
	 * @return 長期移動平均の期間
	 */
	public int getSlow() { return slow; }

	/**
	 * 長期移動平均の期間を設定します。
	 * 
	 * @param slow 長期移動平均の期間
	 */
	public void setSlow(int slow) { this.slow = slow; }

	/**
	 * 移動平均の種類を保持します。
	 */
	private MovingAverage type = MovingAverage.SMA;

	/**
	 * 移動平均の種類を返します。
	 * 
	 * @return 移動平均の種類
	 */
	public MovingAverage getType() { return type; }

	/**
	 * 移動平均の種類を設定します。
	 * 
	 * @param type 移動平均の種類
	 */
	public void setType(MovingAverage type) { this.type = type; }

	// ----------------------------------------------------------------------

	/**
	 * 短期移動平均と長期移動平均の交差シグナルを保持します。
	 */
	protected CrossSignal[] cross;

	@Override
	public void init() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		final Number[] ma_fast = ma(price, this.fast, this.type);
		final Number[] ma_slow = ma(price, this.slow, this.type);
		this.cross = cross(ma_fast, ma_slow);
	}

	@Override
	public void terminate() {
		this.cross = null;
	}

}
