/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.CrossSignal.DEAD_CROSS;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;

/**
 * 価格と移動平均のデッドクロスで売りポジションを建てるストラテジーを提供します。
 */
public class MovingAverageCrossShortEntry extends MovingAverageCross {

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == DEAD_CROSS)
			sellShort(getStrategyName());
		return NEXT;
	}

}
