/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.CrossSignal.DEAD_CROSS;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.chg;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.rsi;
import static jp.sourceforge.orangesignal.trading.strategy.StrategyStatus.NEXT;
import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

public class RSIShortEntry extends StrategySupport {

	private FourPrice price = FourPrice.CLOSE;
	public FourPrice getPrice() { return price; }
	public void setPrice(final FourPrice price) { this.price = price; }

	private int period = 14;
	public int getPeriod() { return period; }
	public void setPeriod(final int period) { this.period = period; }

	private double signal = 70;
	public double getSignal() { return signal; }
	public void setSignal(final double signal) { this.signal = signal; }

	// ----------------------------------------------------------------------

	private CrossSignal[] cross;

	@Override
	public void init() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		this.cross = cross(rsi(chg(price), this.period), signal);
	}

	@Override
	public StrategyStatus process() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == DEAD_CROSS)
			sellShort(getStrategyName());
		return NEXT;
	}

	@Override
	public void terminate() {
		this.cross = null;
	}

}
