package jp.sourceforge.orangesignal.trading.commission;

import static org.junit.Assert.assertTrue;
import jp.sourceforge.orangesignal.ta.PercentageScale;

import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;

public class RateCommissionTest {

	@Test
	public void testRateCommission() {
		new RateCommission();
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoublePercentageScale() {
		new RateCommission(5, PercentageScale.PERCENT);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoublePercentageScaleDouble() {
		new RateCommission(5, PercentageScale.PERCENT, 20);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoublePercentageScaleDoubleDouble() {
		new RateCommission(5, PercentageScale.PERCENT, 50, 2500);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoublePercentageScaleDoubleDoubleDouble() {
		new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoubleDoublePercentageScale() {
		new RateCommission(0, 5, PercentageScale.PERCENT);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoubleDoublePercentageScaleDouble() {
		new RateCommission(0, 5, PercentageScale.PERCENT, 20);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoubleDoublePercentageScaleDoubleDouble() {
		new RateCommission(0, 5, PercentageScale.PERCENT, 50, 2500);
		assertTrue(true);
	}

	@Test
	public void testRateCommissionDoubleDoublePercentageScaleDoubleDoubleDouble() {
		new RateCommission(0, 5, PercentageScale.PERCENT, 20, 50, 2500);
		assertTrue(true);
	}

	@Test
	public void testGetRate() {
		assertTrue(new RateCommission().getRate() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT).getRate() == 5D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).getRate() == 5D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).getRate() == 5D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).getRate() == 5D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT).getRate() == 5D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20).getRate() == 5D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 50, 2500).getRate() == 5D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20, 50, 2500).getRate() == 5D);
	}

	@Test
	public void testSetRate() {
		final RateCommission commission = new RateCommission();
		commission.setRate(5);
		assertTrue(commission.getRate() == 5D);
	}

	@Test
	public void testGetScale() {
		assertTrue(new RateCommission().getScale() == PercentageScale.PERCENT);

		assertTrue(new RateCommission(5, PercentageScale.PERCENT).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 50, 2500).getScale() == PercentageScale.PERCENT);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20, 50, 2500).getScale() == PercentageScale.PERCENT);

		assertTrue(new RateCommission(0.05, PercentageScale.RATE).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0.05, PercentageScale.RATE, 20).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0.05, PercentageScale.RATE, 50, 2500).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0.05, PercentageScale.RATE, 20, 50, 2500).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0, 0.05, PercentageScale.RATE).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0, 0.05, PercentageScale.RATE, 20).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0, 0.05, PercentageScale.RATE, 50, 2500).getScale() == PercentageScale.RATE);
		assertTrue(new RateCommission(0, 0.05, PercentageScale.RATE, 20, 50, 2500).getScale() == PercentageScale.RATE);
	}

	@Test
	public void testSetScale() {
		final RateCommission commission = new RateCommission();
		commission.setScale(PercentageScale.RATE);
		assertTrue(commission.getScale() == PercentageScale.RATE);
	}

	@Test
	public void testGetAdding() {
		assertTrue(new RateCommission().getAdding() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT).getAdding() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).getAdding() == 20D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).getAdding() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).getAdding() == 20D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT).getAdding() == 0D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20).getAdding() == 20D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 50, 2500).getAdding() == 0D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20, 50, 2500).getAdding() == 20D);
	}

	@Test
	public void testSetAdding() {
		final RateCommission commission = new RateCommission();
		commission.setAdding(20);
		assertTrue(commission.getAdding() == 20D);
	}

	@Test
	public void testGetMin() {
		assertTrue(new RateCommission().getMin() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT).getMin() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).getMin() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).getMin() == 50D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).getMin() == 50D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT).getMin() == 0D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20).getMin() == 0D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 50, 2500).getMin() == 50D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20, 50, 2500).getMin() == 50D);
	}

	@Test
	public void testSetMin() {
		final RateCommission commission = new RateCommission();
		commission.setMin(50);
		assertTrue(commission.getMin() == 50D);
	}

	@Test
	public void testGetMax() {
		assertTrue(new RateCommission().getMax() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT).getMax() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).getMax() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).getMax() == 2500D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).getMax() == 2500D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT).getMax() == 0D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20).getMax() == 0D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 50, 2500).getMax() == 2500D);
		assertTrue(new RateCommission(0, 5, PercentageScale.PERCENT, 20, 50, 2500).getMax() == 2500D);
	}

	@Test
	public void testSetMax() {
		final RateCommission commission = new RateCommission();
		commission.setMax(2500);
		assertTrue(commission.getMax() == 2500D);
	}

	@Test
	public void testCalcCommission() {
		assertTrue(new RateCommission().calcCommission(10000, 100) == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT).calcCommission(10000, 100) == 50000D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).calcCommission(10000, 100) == 50020D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).calcCommission(10000, 100) == 2500D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).calcCommission(10000, 100) == 2500D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT).calcCommission(10000, 100) == 50000D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT, 20).calcCommission(10000, 100) == 50020D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT, 50, 2500).calcCommission(10000, 100) == 2500D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT, 20, 50, 2500).calcCommission(10000, 100) == 2500D);
	}

	@Test
	public void testGetBase() {
		assertTrue(new RateCommission().getBase() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT).getBase() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20).getBase() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 50, 2500).getBase() == 0D);
		assertTrue(new RateCommission(5, PercentageScale.PERCENT, 20, 50, 2500).getBase() == 0D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT).getBase() == 100D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT, 20).getBase() == 100D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT, 50, 2500).getBase() == 100D);
		assertTrue(new RateCommission(100, 5, PercentageScale.PERCENT, 20, 50, 2500).getBase() == 100D);
	}

	@Test
	public void testSetBase() {
		final RateCommission commission = new RateCommission();
		commission.setBase(100);
		assertTrue(commission.getBase() == 100D);
	}

	@Test
	public void testCompareTo() {
		final CommissionUnit commission0 = new RateCommission(50, 5, PercentageScale.PERCENT);
		final CommissionUnit commission1 = new RateCommission(50, 5, PercentageScale.PERCENT);
		final CommissionUnit commission2 = new RateCommission(100, 5, PercentageScale.PERCENT);
		final CommissionUnit commission3 = new RateCommission(200, 5, PercentageScale.PERCENT);
		assertTrue(commission1.compareTo(commission0) == 0);
		assertTrue(commission1.compareTo(commission1) == 0);
		assertTrue(commission1.compareTo(commission2) < 0);
		assertTrue(commission1.compareTo(commission3) < 0);
		assertTrue(commission3.compareTo(commission0) > 0);
	}

	@Test(expected = NullPointerException.class)
	public void testCompareToNullPointerException() {
		new RateCommission().compareTo(null);
	}

	@Test
	public void testSerialization() {
		final byte[] bytes = SerializationUtils.serialize(new RateCommission());
		assertTrue(true);
		final Object obj = SerializationUtils.deserialize(bytes);
		assertTrue(obj instanceof RateCommission);
	}

}
