/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta;

/**
 * 百分率の尺度を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum PercentageScale {

	/**
	 * 1 を基準とした尺度を表します。
	 */
	RATE { @Override public double scale() { return 1.0; } },

	/**
	 * 100 を基準とした尺度を表します。
	 */
	PERCENT { @Override public double scale() { return 100.0; } },

	/**
	 * -1 を基準とした尺度を表します。
	 */
	REVERSE_RATE { @Override public double scale() { return -1.0; } },

	/**
	 * -100 を基準とした尺度を表します。
	 */
	REVERSE_PERCENT { @Override public double scale() { return -100.0; } };

	/**
	 * この列挙型が表す尺度の基準値を返します。
	 * 
	 * @return 尺度の上限値
	 */
	public abstract double scale();

}
