/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset.loader;

import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset;

/**
 * データセットロード機能のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 * @since 1.1
 */
public interface DatasetLoader {

	/**
	 * シンボルを設定します。
	 * 
	 * @param symbol シンボル
	 */
	public void setSymbol(String symbol);

	/**
	 * データセットをロードして返します。
	 * 
	 * @return データセット
	 * @throws LoadException データセットのロードに失敗した場合
	 */
	public TimeSeriesDataset load() throws LoadException;

}
