/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.dataset.loader;

/**
 * コンバーターが変換処理に失敗した場合にスローする例外クラスを提供します。
 * 
 * @author 杉澤 浩二
 * @since 1.1
 */
public class LoadException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public LoadException() {
		super();
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 */
	public LoadException(final String message) {
		super(message);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 * @param cause 原因
	 */
	public LoadException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param cause 原因
	 */
	public LoadException(final Throwable cause) {
		super(cause);
	}

}
