package jp.sourceforge.orangesignal.ta;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class PercentageScaleTest {

	@Test
	public void values() {
		final PercentageScale[] values = PercentageScale.values();
		for (final PercentageScale value : values) {
			switch (value) {
				case RATE: case PERCENT: case REVERSE_RATE: case REVERSE_PERCENT:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void RATE_scale() {
		assertThat(PercentageScale.RATE.scale(), is(1.0));
	}

	@Test
	public void PERCENT_scale() {
		assertThat(PercentageScale.PERCENT.scale(), is(100.0));
	}

	@Test
	public void REVERSE_RATE_scale() {
		assertThat(PercentageScale.REVERSE_RATE.scale(), is(-1.0));
	}

	@Test
	public void REVERSE_PERCENT_scale() {
		assertThat(PercentageScale.REVERSE_PERCENT.scale(), is(-100.0));
	}

}
