/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.systems;

import static jp.sourceforge.orangesignal.ta.CrossSignal.DEAD_CROSS;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.bbands;
import static jp.sourceforge.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sourceforge.orangesignal.ta.result.Bands5.UPPER_BAND1;
import static jp.sourceforge.orangesignal.trading.order.OrderTiming.NEXT_STOP;

import java.util.Map;

import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.ta.result.Bands5;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.TradingStrategySupport;

public class BollingerBandsShortEntry extends TradingStrategySupport {

	/**
	 * 4本値の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 4本値の種類を返します。
	 * 
	 * @return 4本値の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 4本値の種類を設定します。
	 * 
	 * @param price 4本値の種類
	 */
	public void setPrice(final FourPrice price) { this.price = price; }

	/**
	 * ボリンジャーバンドの期間を保持します。
	 */
	private int period = 20;

	/**
	 * ボリンジャーバンドの期間を返します。
	 * 
	 * @return ボリンジャーバンドの期間
	 */
	public int getPeriod() { return period; }

	/**
	 * ボリンジャーバンドの期間を設定します。
	 * 
	 * @param period ボリンジャーバンドの期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	private int num = 2;
	public int getNum() { return num; }
	public void setNum(final int num) { this.num = num; }

	// ----------------------------------------------------------------------

	/**
	 * ボリンジャーバンドの上位バンドデータを保持します。
	 */
	protected Number[] bb;

	/**
	 * 価格とボリンジャーバンドの上位バンドとの交差シグナルを保持します。
	 */
	protected CrossSignal[] cross;

	@Override
	public void prepare() {
		final StandardDataset dataset = getDataset();

		// ボリンジャーバンドの下位バンドを取得します。
		final Number[] high = dataset.getTechnicalHigh();
		final Number[] low = dataset.getTechnicalLow();
		final Number[] close = dataset.getTechnicalClose();
		final Map<Bands5, Number[]> map = bbands(high, low, close, this.period, this.num);
		this.bb = map.get(UPPER_BAND1);

		final Number[] price = getDataset().getTechnicalPrice(this.price);
		this.cross = cross(price, this.bb);
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == DEAD_CROSS)
			sellShort(getStrategyName(), NEXT_STOP, bb[i].doubleValue());
		return false;
	}

	@Override
	public void close() {
		this.bb = null;
		this.cross = null;
	}

}
