/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

/**
 * 非時系列の軸情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class StepAxis extends Axis {

	/**
	 * デフォルトコンストラクタです。
	 */
	public StepAxis() {
		setOrientation(Orientation.HORIZONTAL);
	}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void refreshTicks() {}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void refreshTicks(final Graphics2D g2, final Rectangle2D chartArea) {}

	// ---------------------------------------- 描画

	/**
	 * 目盛りやグリッド線を描画します。
	 * 
	 * @param g2 Graphics2D オブジェクト
	 * @param chartArea 描画領域
	 */
	public void draw(final Graphics2D g2, final Rectangle2D chartArea) {
		g2.setFont(FONT);
		final double top = chartArea.getMaxY() + getTickMarkOutsideLength();
		// 線
		drawAxisLine(g2, chartArea.getMinX(), top, chartArea.getMaxX(), top);
	}

	/**
	 * トレーサーを描画します。
	 * 
	 * @param g2 Graphics2D オブジェクト
	 * @param chartArea 描画領域
	 * @param x X 座標
	 */
	public void drawAxisTrace(final Graphics2D g2, final Rectangle2D chartArea, final double x) {
		// トレース線を描画します。
		drawTraceLine(g2, x, chartArea.getMinY(), x, chartArea.getMaxY());
	}

}
