/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 基底の価格単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public abstract class PriceUnits implements Serializable {

	private static final long serialVersionUID = 2442053518299439818L;

	/**
	 * 価格単位情報のリストを保持します。
	 */
	protected List<PriceUnit> units = new ArrayList<PriceUnit>();

	/**
	 * 指定された価格単位情報をリストへ追加します。
	 * 
	 * @param unit 価格単位情報
	 */
	public void add(final PriceUnit unit) {
		units.add(unit);
        Collections.sort(units);
	}

	public PriceUnit getCeilingPriceUnit(final PriceUnit unit) {
		int index = Collections.binarySearch(units, unit);
		if (index >= 0) {
			return units.get(index);
		}

		index = -(index + 1);
		return units.get(Math.min(index, units.size() - 1));
    }

	public PriceUnit getCeilingPriceUnit(final int price) {
		return getCeilingPriceUnit(new PriceUnit(price, 0D));
	}

}
