/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.event;

import static jp.sf.orangesignal.chart.ui.DatasetType.DAILY;
import static jp.sf.orangesignal.chart.ui.DatasetType.MONTHLY;
import static jp.sf.orangesignal.chart.ui.DatasetType.WEEKLY;
import static jp.sf.orangesignal.chart.ui.PeriodType.ALL;
import static jp.sf.orangesignal.chart.ui.PeriodType.SIX_MONTH;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.data.ChartDataset;

import org.junit.Test;

/**
 * {@link ChartEvent} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class ChartEventTest {

	@Test
	public void testChartEvent() {
		// Act
		final ChartEvent event = new ChartEvent(this, null, DAILY, SIX_MONTH, false, null);
		// Assert
		assertEquals(event.getSource(), this);
	}

	@Test
	public void testGetDataset() {
		// Arrange
		final ChartDataset dataset = new BasicChartDataset();
		final ChartEvent event = new ChartEvent(this, dataset, DAILY, SIX_MONTH, false, null);
		// Act + Assert
		assertEquals(event.getDataset(), dataset);
	}

	@Test
	public void testGetType() {
		assertThat(new ChartEvent(this, null, DAILY, SIX_MONTH, false, null).getType(), is(DAILY));
		assertThat(new ChartEvent(this, null, WEEKLY, SIX_MONTH, false, null).getType(), is(WEEKLY));
		assertThat(new ChartEvent(this, null, MONTHLY, SIX_MONTH, false, null).getType(), is(MONTHLY));
	}

	@Test
	public void testGetPeriodType() {
		assertThat(new ChartEvent(this, null, DAILY, SIX_MONTH, false, null).getPeriodType(), is(SIX_MONTH));
		assertThat(new ChartEvent(this, null, DAILY, ALL, false, null).getPeriodType(), is(ALL));
	}

	@Test
	public void testGetStart() {
		assertThat(new ChartEvent(this, null, DAILY, SIX_MONTH, false, null).getStart(), is(0));
	}

	@Test
	public void testIsIgnoreStart() {
		assertFalse(new ChartEvent(this, null, DAILY, SIX_MONTH, false, null).isIgnoreStart());
		assertTrue(new ChartEvent(this, null, DAILY, SIX_MONTH, true, null).isIgnoreStart());
	}

	@Test
	public void testGetPeriod() {
		assertThat(new ChartEvent(this, null, DAILY, SIX_MONTH, false, null).getPeriod(), is(0));
	}

	@Test
	public void testGetSettings() {
		// Arrange
		final ChartSettings settings = new ChartSettings();
		final ChartEvent event = new ChartEvent(this, null, DAILY, SIX_MONTH, false, settings);
		// Act + Assert
		assertEquals(event.getSettings(), settings);
	}

}
