/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

import java.util.List;

import jp.sf.orangesignal.ta.Step;
import jp.sf.orangesignal.ta.candle.TrendType;

/**
 * ポイント＆フィギュアデータからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class PointFigureTrendProcessor extends StepTrendProcessor {

	/**
	 * コンストラクタです。
	 * 
	 * @param pf ポイント＆フィギュアデータ
	 */
	public PointFigureTrendProcessor(final List<Step> pf) {
		super(pf);
	}

	@Override
	protected TrendType getTrend(final Step pf) {
		if (pf.lowDate.compareTo(pf.highDate) < 0)
			return TrendType.UP;	// × 上昇トレンド
		return TrendType.DOWN;	// ○ 下降トレンド
	}

}
