package jp.sf.orangesignal.trading;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import jp.sf.orangesignal.trading.MarketPositionType;

import org.junit.Test;

public class MarketPositionTypeTest {

	@SuppressWarnings("deprecation")
	@Test
	public void testValues() {
		final MarketPositionType[] values = MarketPositionType.values();
		for (final MarketPositionType value : values) {
			switch (value) {
				case FLAT:
				case LONG:
				case SHORT:
				case HEDGE:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@SuppressWarnings("deprecation")
	@Test
	public void testIsFlat() {
		assertTrue(MarketPositionType.FLAT.isFlat());
		assertFalse(MarketPositionType.LONG.isFlat());
		assertFalse(MarketPositionType.SHORT.isFlat());
		assertFalse(MarketPositionType.HEDGE.isFlat());
	}

	@SuppressWarnings("deprecation")
	@Test
	public void testIsLong() {
		assertFalse(MarketPositionType.FLAT.isLong());
		assertTrue(MarketPositionType.LONG.isLong());
		assertFalse(MarketPositionType.SHORT.isLong());
		assertTrue(MarketPositionType.HEDGE.isLong());
	}

	@SuppressWarnings("deprecation")
	@Test
	public void testIsShort() {
		assertFalse(MarketPositionType.FLAT.isShort());
		assertFalse(MarketPositionType.LONG.isShort());
		assertTrue(MarketPositionType.SHORT.isShort());
		assertTrue(MarketPositionType.HEDGE.isShort());
	}

	@SuppressWarnings("deprecation")
	@Test
	public void testValueOf() {
		assertTrue(MarketPositionType.valueOf(false, false) == MarketPositionType.FLAT);
		assertTrue(MarketPositionType.valueOf(true, false) == MarketPositionType.LONG);
		assertTrue(MarketPositionType.valueOf(false, true) == MarketPositionType.SHORT);
		assertTrue(MarketPositionType.valueOf(true, true) == MarketPositionType.HEDGE);
	}

}
