/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart;

import java.awt.Font;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * フォントの定数定義クラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public abstract class FontConstants {

	/**
	 * ラベルやボタンなどのGUI用フォントです。
	 */
	public static final Font FONT_GUI = new Font(StringManager.getString("font.gui"), Font.PLAIN, 10);

	/**
	 * 英数字用のフォントです。
	 */
	public static final Font FONT_INDEX = new Font(StringManager.getString("font.value"), Font.PLAIN, 12);

	/**
	 * 英数字用の小さいフォントです。
	 */
	public static final Font FONT_INDEX_SMALL = new Font(StringManager.getString("font.value"), Font.PLAIN, 10);

	/**
	 * 日本語用のフォントです。
	 */
	public static final Font FONT_MESSAGE = new Font(StringManager.getString("font.message"), Font.PLAIN, 12);

}
