/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.VolatileImage;

/**
 * チャート描画用キャンバスの基底クラスを提供します。
 * このキャンバスはダブルバッファリング機能を提供します。
 * 
 * @author 杉澤 浩二
 */
public abstract class DoubleBufferedCanvas extends Canvas {

	private static final long serialVersionUID = -715400898691581874L;

	@Override
	public void paint(final Graphics g) {
		final int width = getWidth();
		final int height = getHeight();
		if (width <= 0 || height <= 0) {
			return;
		}

		VolatileImage image = createVolatileImage(width, height);
		do {
			if (image.validate(getGraphicsConfiguration()) == VolatileImage.IMAGE_INCOMPATIBLE) {
				image = createVolatileImage(width, height);
			}
			if (image == null) {
				return;
			}

			final Graphics2D g2 = image.createGraphics();
			setRenderingHints(g2);
			draw(g2);
			g2.dispose();
			g.drawImage(image, 0, 0, this);
		} while (image.contentsLost());
		image.flush();
	}

	/**
	 * 実装は単に {@link #paint(Graphics)} を呼び出します。
	 */
	@Override
	public void update(final Graphics g) {
		paint(g);
	}

	public abstract void setRenderingHints(Graphics2D g2);

	/**
	 * このキャンバスをペイントします。
	 * 
	 * @param g2 指定された Graphics コンテキスト
	 * @see java.awt.Canvas#update(java.awt.Graphics)
	 * @see java.awt.Component#paint(java.awt.Graphics)
	 */
	public abstract void draw(Graphics2D g2);

}
