/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.BorderLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

import javax.swing.JScrollBar;

import jp.sf.orangesignal.chart.data.AntiWatchChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.canvas.AntiWatchCanvas;

/**
 * 逆ウォッチ曲線画面を提供します。
 * 
 * @author 杉澤 浩二
 */
public class AntiWatchScreen extends ChartScreen implements AdjustmentListener {

	private static final long serialVersionUID = -5765368008796724675L;

	/**
	 * 主画面を保持します。
	 */
	private final AntiWatchCanvas canvas;

	/**
	 * スクロールバーを保持します。
	 */
	private JScrollBar scrollbar = new JScrollBar(JScrollBar.HORIZONTAL, 0, 0, 0, 0);

	/**
	 * コンストラクタです。
	 * 
	 * @param icons アイコン情報
	 */
	public AntiWatchScreen(final Icons icons) {
		// 各コントロールを初期化します。
		canvas = new AntiWatchCanvas(icons, this);
		scrollbar.addAdjustmentListener(this);

		// レイアウトを処理します。
		setLayout(new BorderLayout());
		add(canvas, BorderLayout.CENTER);
		add(scrollbar, BorderLayout.SOUTH);

	}

	@Override public void datasetSwitch(final ChartEvent e) { processChartEvent(e); }
	@Override public void periodSwitch(final ChartEvent e) { processChartEvent(e); }
	@Override public void settingChanged(final ChartEvent e) { processChartEvent(e); }

	private void processChartEvent(final ChartEvent e) {
		if (!e.isIgnoreStart()) {
			final AntiWatchChartDataset dataset = (AntiWatchChartDataset) e.getDataset();
			if (dataset == null) {
				scrollbar.setMaximum(0);
				scrollbar.setVisibleAmount(0);
				scrollbar.setValue(0);
				scrollbar.setBlockIncrement(0);
				scrollbar.setEnabled(false);
			} else {
				// 設定順序に気おつけること
				// @see javax.swing.DefaultBoundedRangeModel
				scrollbar.setValue(0);	// XXX - 最初にこれ重要
				scrollbar.setMaximum(dataset.getCount());
				scrollbar.setVisibleAmount(e.getPeriod());
				scrollbar.setValue(e.getStart());
				scrollbar.setBlockIncrement(e.getPeriod() / 2);
				scrollbar.setEnabled(true);
			}
		}

		canvas.switchDataset(e);
	}

	@Override
	public void adjustmentValueChanged(final AdjustmentEvent e) {
		canvas.setStart(e.getValue());
	}

}
