/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;

import jp.sf.orangesignal.chart.event.ChartListener;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.event.ChartScreenListener;
import jp.sf.orangesignal.chart.ui.ChartScreenType;

/**
 * チャート画面の抽象クラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public abstract class ChartScreen extends JPanel implements ChartListener {

	private static final long serialVersionUID = -6137789945363220246L;

	/**
	 * チャート画面リスナーのリストを保持します。
	 */
	protected final List<ChartScreenListener> listeners = new ArrayList<ChartScreenListener>(1);

	/**
	 * 指定されたチャート画面リスナーをリストへ追加します。
	 * 
	 * @param listener チャート画面リスナー
	 */
	public final void addChartScreenListener(final ChartScreenListener listener) {
		this.listeners.add(listener);
	}

	/**
	 * 登録されているすべてのチャート画面リスナーへ <code>positionChanged</code> を通知します。
	 * 
	 * @param event チャート画面のイベント
	 */
	public final void sendPositionChanged(final ChartScreenEvent event) {
		for (ChartScreenListener listener : this.listeners)
			listener.positionChanged(event);
	}

	/**
	 * この画面の種類を保持します。既定の値は <code>null</code> です。
	 */
	private ChartScreenType screenType = null;

	/**
	 * この画面の種類を返します。不明な場合は <code>null</code> を返します。
	 * 
	 * @return 画面の種類
	 */
	public final ChartScreenType getScreenType() { return screenType; }

	/**
	 * この画面の種類を設定します。
	 * 
	 * @param screenType 画面の種類
	 */
	public final void setScreenType(final ChartScreenType screenType) { this.screenType = screenType; }

}
