/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * {@link ChartScreenType} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class ChartScreenTypeTest {

	@Test
	public void testValues() {
		final ChartScreenType[] values = ChartScreenType.values();
		for (final ChartScreenType value : values) {
			switch (value) {
				case NONE:
				case TIME_SERIES:
				case POINT_AND_FIGURE:
				case KAGI:
				case RENKOH:
				case SHINNE:
				case ANTI_WATCH:
				case HISTORICAL_DATA:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void testToString() {
		assertNotNull(ChartScreenType.NONE.toString());
		assertNotNull(ChartScreenType.TIME_SERIES.toString());
		assertNotNull(ChartScreenType.POINT_AND_FIGURE.toString());
		assertNotNull(ChartScreenType.KAGI.toString());
		assertNotNull(ChartScreenType.RENKOH.toString());
		assertNotNull(ChartScreenType.SHINNE.toString());
		assertNotNull(ChartScreenType.ANTI_WATCH.toString());
		assertNotNull(ChartScreenType.HISTORICAL_DATA.toString());
	}

}
