/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import java.awt.Color;

import jp.sf.orangesignal.chart.ChartColor;

import org.junit.Test;

/**
 * {@link UpDownColorType} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class UpDownColorTypeTest {

	@Test
	public void testValues() {
		final UpDownColorType[] values = UpDownColorType.values();
		for (final UpDownColorType value : values) {
			switch (value) {
				case RED_BLUE:
				case GREEN_RED:
				case RED_BLACK:
				case WHITE_BLACK:
				case WHITE_BLUE_RED_OUTLINE:
				case WHITE_BLUE_BLUE_OUTLINE:
				case WHITE_BLUE_BLACK_OUTLINE:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void testGetUpColor1() {
		assertThat(UpDownColorType.RED_BLUE.getUpColor1(), is(ChartColor.VERY_LIGHT_RED));
		assertThat(UpDownColorType.GREEN_RED.getUpColor1(), is(ChartColor.GREEN));
		assertThat(UpDownColorType.RED_BLACK.getUpColor1(), is(ChartColor.VERY_LIGHT_RED));
		assertThat(UpDownColorType.WHITE_BLACK.getUpColor1(), is(Color.WHITE));
		assertThat(UpDownColorType.WHITE_BLUE_RED_OUTLINE.getUpColor1(), is(Color.WHITE));
		assertThat(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.getUpColor1(), is(Color.WHITE));
		assertThat(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.getUpColor1(), is(Color.WHITE));
	}

	@Test
	public void testGetUpColor2() {
		assertThat(UpDownColorType.RED_BLUE.getUpColor2(), is(Color.RED));
		assertThat(UpDownColorType.GREEN_RED.getUpColor2(), is(ChartColor.DARK_GREEN));
		assertThat(UpDownColorType.RED_BLACK.getUpColor2(), is(Color.RED));
		assertThat(UpDownColorType.WHITE_BLACK.getUpColor2(), is(ChartColor.VERY_LIGHT_GRAY));
		assertThat(UpDownColorType.WHITE_BLUE_RED_OUTLINE.getUpColor2(), is(ChartColor.VERY_VERY_LIGHT_RED));
		assertThat(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.getUpColor2(), is(ChartColor.VERY_VERY_LIGHT_BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.getUpColor2(), is(ChartColor.VERY_LIGHT_GRAY));
	}

	@Test
	public void testGetUpLineColor() {
		assertThat(UpDownColorType.RED_BLUE.getUpLineColor(), is(Color.RED));
		assertThat(UpDownColorType.GREEN_RED.getUpLineColor(), is(ChartColor.DARK_GREEN));
		assertThat(UpDownColorType.RED_BLACK.getUpLineColor(), is(Color.RED));
		assertThat(UpDownColorType.WHITE_BLACK.getUpLineColor(), is(Color.BLACK));
		assertThat(UpDownColorType.WHITE_BLUE_RED_OUTLINE.getUpLineColor(), is(Color.RED));
		assertThat(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.getUpLineColor(), is(Color.BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.getUpLineColor(), is(Color.BLACK));
	}

	@Test
	public void testGetDownColor1() {
		assertThat(UpDownColorType.RED_BLUE.getDownColor1(), is(ChartColor.VERY_LIGHT_BLUE));
		assertThat(UpDownColorType.GREEN_RED.getDownColor1(), is(ChartColor.VERY_LIGHT_RED));
		assertThat(UpDownColorType.RED_BLACK.getDownColor1(), is(ChartColor.LIGHT_GRAY));
		assertThat(UpDownColorType.WHITE_BLACK.getDownColor1(), is(Color.LIGHT_GRAY));
		assertThat(UpDownColorType.WHITE_BLUE_RED_OUTLINE.getDownColor1(), is(Color.BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.getDownColor1(), is(Color.BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.getDownColor1(), is(Color.BLUE));
	}

	@Test
	public void testGetDownColor2() {
		assertThat(UpDownColorType.RED_BLUE.getDownColor2(), is(Color.BLUE));
		assertThat(UpDownColorType.GREEN_RED.getDownColor2(), is(Color.RED));
		assertThat(UpDownColorType.RED_BLACK.getDownColor2(), is(Color.BLACK));
		assertThat(UpDownColorType.WHITE_BLACK.getDownColor2(), is(Color.BLACK));
		assertThat(UpDownColorType.WHITE_BLUE_RED_OUTLINE.getDownColor2(), is(ChartColor.VERY_DARK_BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.getDownColor2(), is(ChartColor.VERY_DARK_BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.getDownColor2(), is(ChartColor.VERY_DARK_BLUE));
	}

	@Test
	public void testGetDownLineColor() {
		assertThat(UpDownColorType.RED_BLUE.getDownLineColor(), is(Color.BLUE));
		assertThat(UpDownColorType.GREEN_RED.getDownLineColor(), is(Color.RED));
		assertThat(UpDownColorType.RED_BLACK.getDownLineColor(), is(Color.BLACK));
		assertThat(UpDownColorType.WHITE_BLACK.getDownLineColor(), is(Color.BLACK));
		assertThat(UpDownColorType.WHITE_BLUE_RED_OUTLINE.getDownLineColor(), is(Color.BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.getDownLineColor(), is(Color.BLUE));
		assertThat(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.getDownLineColor(), is(Color.BLACK));
	}

	@Test
	public void testToString() {
		assertNotNull(UpDownColorType.RED_BLUE.toString());
		assertNotNull(UpDownColorType.GREEN_RED.toString());
		assertNotNull(UpDownColorType.RED_BLACK.toString());
		assertNotNull(UpDownColorType.WHITE_BLACK.toString());
		assertNotNull(UpDownColorType.WHITE_BLUE_RED_OUTLINE.toString());
		assertNotNull(UpDownColorType.WHITE_BLUE_BLUE_OUTLINE.toString());
		assertNotNull(UpDownColorType.WHITE_BLUE_BLACK_OUTLINE.toString());
	}

}
