/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

/**
 * {@link Assert} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class AssertTest {

	@Test
	public void testIsTrueBooleanString() {
		// Act
		Assert.isTrue(true, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsTrueBooleanStringIllegalArgumentException() {
		// Act
		Assert.isTrue(false, "");
	}

	@Test
	public void testIsTrueBoolean() {
		// Act
		Assert.isTrue(true);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsTrueBooleanIllegalArgumentException() {
		// Act
		Assert.isTrue(false);
	}

	@Test
	public void testIsFalseBooleanString() {
		// Act
		Assert.isFalse(false, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsFalseBooleanStringIllegalArgumentException() {
		// Act
		Assert.isFalse(true, "");
	}

	@Test
	public void testIsFalseBoolean() {
		// Act
		Assert.isFalse(false);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsFalseBooleanIllegalArgumentException() {
		// Act
		Assert.isFalse(true);
	}

	@Test
	public void testIsNullObjectString() {
		// Act
		Assert.isNull(null, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsNullObjectStringIllegalArgumentException() {
		// Act
		Assert.isNull(new Object(), "");
	}

	@Test
	public void testIsNullObject() {
		// Act
		Assert.isNull(null);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsNullObjectIllegalArgumentException() {
		// Act
		Assert.isNull(new Object());
	}

	@Test
	public void testNotNullObjectString() {
		// Act
		Assert.notNull(new Object(), "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotNullObjectStringIllegalArgumentException() {
		// Act
		Assert.notNull(null, "");
	}

	@Test
	public void testNotNullObject() {
		// Act
		Assert.notNull(new Object());
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotNullObjectIllegalArgumentException() {
		// Act
		Assert.notNull(null);
	}

	@Test
	public void testIsEmptyStringString() {
		// Arrange
		String str = null;
		// Act
		Assert.isEmpty(str, "");
		// Act
		Assert.isEmpty("", "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyStringStringIllegalArgumentException() {
		// Act
		Assert.isEmpty("abc", "");
	}

	@Test
	public void testIsEmptyString() {
		// Arrange
		String str = null;
		// Act
		Assert.isEmpty(str);
		// Act
		Assert.isEmpty("");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyStringIllegalArgumentException() {
		// Act
		Assert.isEmpty("abc");
	}

	@Test
	public void testIsEmptyObjectArrayString() {
		// Arrange
		Object[] array = null;
		// Act
		Assert.isEmpty(array, "");
		// Act
		Assert.isEmpty(new Object[0], "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyObjectArrayStringIllegalArgumentException() {
		// Act
		Assert.isEmpty(new Object[]{ "abc" }, "");
	}

	@Test
	public void testIsEmptyObjectArray() {
		// Arrange
		Object[] array = null;
		// Act
		Assert.isEmpty(array);
		// Act
		Assert.isEmpty(new Object[0]);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyObjectArrayIllegalArgumentException() {
		// Act
		Assert.isEmpty(new Object[]{ "abc" });
	}

	@Test
	public void testIsEmptyCollectionOfQString() {
		// Arrange
		Collection<Object> collection = null;
		// Act
		Assert.isEmpty(collection, "");
		// Arrange
		collection = new ArrayList<Object>(0);
		// Act
		Assert.isEmpty(collection, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyCollectionOfQStringIllegalArgumentException() {
		// Arrange
		final Collection<Object> collection = new ArrayList<Object>(1);
		collection.add("abc");
		// Act
		Assert.isEmpty(collection, "");
	}

	@Test
	public void testIsEmptyCollectionOfQ() {
		// Arrange
		Collection<Object> collection = null;
		// Act
		Assert.isEmpty(collection);
		// Arrange
		collection = new ArrayList<Object>(0);
		// Act
		Assert.isEmpty(collection);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyCollectionOfQIllegalArgumentException() {
		// Arrange
		final Collection<Object> collection = new ArrayList<Object>(1);
		collection.add("abc");
		// Act
		Assert.isEmpty(collection);
	}

	@Test
	public void testIsEmptyMapOfQQString() {
		// Arrange
		Map<String, Object> map = null;
		// Act
		Assert.isEmpty(map, "");
		// Arrange
		map = new HashMap<String, Object>();
		// Act
		Assert.isEmpty(map, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyMapOfQQStringIllegalArgumentException() {
		// Arrange
		final Map<String, Object> map = new HashMap<String, Object>();
		map.put("abc", null);
		// Act
		Assert.isEmpty(map, "");
	}

	@Test
	public void testIsEmptyMapOfQQ() {
		// Arrange
		Map<String, Object> map = null;
		// Act
		Assert.isEmpty(map);
		// Arrange
		map = new HashMap<String, Object>();
		// Act
		Assert.isEmpty(map);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsEmptyMapOfQQIllegalArgumentException() {
		// Arrange
		final Map<String, Object> map = new HashMap<String, Object>();
		map.put("abc", null);
		// Act
		Assert.isEmpty(map, "");
	}

	@Test
	public void testNotEmptyStringString() {
		// Act
		Assert.notEmpty("abc", "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyStringStringIllegalArgumentException1() {
		// Arrange
		String str = null;
		// Act
		Assert.notEmpty(str, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyStringStringIllegalArgumentException2() {
		// Act
		Assert.notEmpty("", "");
	}

	@Test
	public void testNotEmptyString() {
		// Act
		Assert.notEmpty("abc");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyStringIllegalArgumentException1() {
		// Arrange
		final String str = null;
		// Act
		Assert.notEmpty(str);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyStringIllegalArgumentException2() {
		// Act
		Assert.notEmpty("");
	}

	@Test
	public void testNotEmptyObjectArrayString() {
		// Act
		Assert.notEmpty(new Object[]{ "abc" }, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyObjectArrayStringIllegalArgumentException1() {
		// Arrange
		final Object[] array = null;
		// Act
		Assert.notEmpty(array, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyObjectArrayStringIllegalArgumentException2() {
		// Act
		Assert.notEmpty(new Object[0], "");
	}

	@Test
	public void testNotEmptyObjectArray() {
		// Act
		Assert.notEmpty(new Object[]{ "abc" });
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyObjectArrayIllegalArgumentException1() {
		// Arrange
		final Object[] array = null;
		// Act
		Assert.notEmpty(array);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyObjectArrayIllegalArgumentException2() {
		// Act
		Assert.notEmpty(new Object[0]);
	}

	@Test
	public void testNotEmptyCollectionOfQString() {
		// Arrange
		final Collection<Object> collection = new ArrayList<Object>();
		collection.add("abc");
		// Act
		Assert.notEmpty(collection, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyCollectionOfQStringIllegalArgumentException1() {
		// Arrange
		final Collection<Object> collection = null;
		// Act
		Assert.notEmpty(collection, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyCollectionOfQStringIllegalArgumentException2() {
		// Act
		Assert.notEmpty(new ArrayList<Object>(0), "");
	}

	@Test
	public void testNotEmptyCollectionOfQ() {
		// Arrange
		final Collection<Object> collection = new ArrayList<Object>();
		collection.add("abc");
		// Act
		Assert.notEmpty(collection);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyCollectionOfQIllegalArgumentException1() {
		// Arrange
		final Collection<Object> collection = null;
		// Act
		Assert.notEmpty(collection);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyCollectionOfQIllegalArgumentException2() {
		// Act
		Assert.notEmpty(new ArrayList<Object>(0));
	}

	@Test
	public void testNotEmptyMapOfQQString() {
		// Arrange
		final Map<String, Object> map = new HashMap<String, Object>();
		map.put("abc", null);
		// Act
		Assert.notEmpty(map, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyMapOfQQStringIllegalArgumentException1() {
		// Act
		Assert.notEmpty(new HashMap<String, Object>(), "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyMapOfQQStringIllegalArgumentException2() {
		// Arrange
		final Map<String, Object> map = null;
		// Act
		Assert.notEmpty(map, "");
	}

	@Test
	public void testNotEmptyMapOfQQ() {
		// Arrange
		final Map<String, Object> map = new HashMap<String, Object>();
		map.put("abc", null);
		// Act
		Assert.notEmpty(map);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyMapOfQQIllegalArgumentException1() {
		// Act
		Assert.notEmpty(new HashMap<String, Object>());
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNotEmptyMapOfQQIllegalArgumentException2() {
		// Arrange
		final Map<String, Object> map = null;
		// Act
		Assert.notEmpty(map);
	}

	@Test
	public void testNoNullElementsObjectArrayString() {
		// Arrange
		final Object[] array = null;
		// Act
		Assert.noNullElements(array, "");
		// Act
		Assert.noNullElements(new Object[0], "");
		// Act
		Assert.noNullElements(new Object[]{ "abc" }, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNoNullElementsObjectArrayStringIllegalArgumentException() {
		// Act
		Assert.noNullElements(new Object[]{ null }, "");
	}

	@Test
	public void testNoNullElementsObjectArray() {
		// Arrange
		final Object[] array = null;
		// Act
		Assert.noNullElements(array);
		// Act
		Assert.noNullElements(new Object[0]);
		// Act
		Assert.noNullElements(new Object[]{ "abc" });
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNoNullElementsObjectArrayIllegalArgumentException() {
		// Act
		Assert.noNullElements(new Object[]{ null });
	}

	@Test
	public void testNoNullElementsCollectionOfQString() {
		// Arrange
		Collection<Object> collection = null;
		// Act
		Assert.noNullElements(collection, "");
		// Act
		Assert.noNullElements(new ArrayList<Object>(0), "");
		// Arrange
		collection = new ArrayList<Object>(1);
		collection.add("abc");
		// Act
		Assert.noNullElements(collection, "");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNoNullElementsCollectionOfQStringIllegalArgumentException() {
		// Arrange
		final Collection<Object> collection = new ArrayList<Object>(1);
		collection.add(null);
		// Act
		Assert.noNullElements(collection, "");
	}

	@Test
	public void testNoNullElementsCollectionOfQ() {
		// Arrange
		Collection<Object> collection = null;
		// Act
		Assert.noNullElements(collection);
		// Act
		Assert.noNullElements(new ArrayList<Object>(0));
		// Arrange
		collection = new ArrayList<Object>(1);
		collection.add("abc");
		// Act
		Assert.noNullElements(collection);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNoNullElementsCollectionOfQIllegalArgumentException() {
		// Arrange
		final Collection<Object> collection = new ArrayList<Object>(1);
		collection.add(null);
		// Act
		Assert.noNullElements(collection);
	}

	@Test
	public void testStateBooleanString() {
		// Act
		Assert.state(true, "");
	}

	@Test(expected = IllegalStateException.class)
	public void testStateBooleanStringIllegalStateException() {
		// Act
		Assert.state(false, "");
	}

	@Test
	public void testStateBoolean() {
		// Act
		Assert.state(true);
	}

	@Test(expected = IllegalStateException.class)
	public void testStateBooleanIllegalStateException() {
		// Act
		Assert.state(false);
	}

}
