DROP TABLE price;
CREATE TABLE price (
	id     VARCHAR(10)   NOT NULL,
	date   DATE          NOT NULL,
	open   DECIMAL(15,6),
	high   DECIMAL(15,6),
	low    DECIMAL(15,6),
	close  DECIMAL(15,6),
	volume DECIMAL(12,0),
	CONSTRAINT pk_price PRIMARY KEY (id, date)
);

INSERT INTO price (id, date, open, high, low, close, volume)
	SELECT 'n225', PARSEDATETIME(a.日付, 'yyyy/MM/dd'), a.始値, a.高値, a.安値, a.終値, a.出来高
	FROM CSVREAD('..\data\n225.csv',null,'Windows-31J') AS a;

INSERT INTO price (id, date, open, high, low, close, volume)
	SELECT 'topix', PARSEDATETIME(a.日付, 'yyyy/MM/dd'), a.始値, a.高値, a.安値, a.終値, a.出来高
	FROM CSVREAD('..\data\topix.csv',null,'Windows-31J') AS a;
